/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug.property;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public class LaunchPropertyTester
extends PropertyTester {
    private static final String LAUNCH_JS = "launchJS";
    private static final String LAUNCH_HTML = "launchHTML";

    public LaunchPropertyTester() {
        System.out.print("");
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class);
        if (!(resource instanceof IFile)) {
            return false;
        }
        if (LAUNCH_JS.equalsIgnoreCase(property)) {
            return this.lauchJS(resource);
        }
        if (LAUNCH_HTML.equalsIgnoreCase(property)) {
            return this.lauchHTML(resource);
        }
        return false;
    }

    private boolean lauchJS(IResource resource) {
        try {
            IProject project = resource.getProject();
            boolean isVJOProject = project.isAccessible() && project.hasNature("org.eclipse.vjet.core.nature");
            boolean isJSFile = "js".equalsIgnoreCase(resource.getFileExtension());
            return isVJOProject && isJSFile;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean lauchHTML(IResource resource) {
        try {
            boolean isHTMLFile;
            IProject project = resource.getProject();
            boolean isVJOProject = project.isAccessible() && project.hasNature("org.eclipse.vjet.core.nature");
            boolean bl = isHTMLFile = "html".equalsIgnoreCase(resource.getFileExtension()) || "htm".equalsIgnoreCase(resource.getFileExtension());
            return isVJOProject && isHTMLFile;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

