/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditorMessages;
import org.eclipse.vjet.eclipse.ui.VjetPreferenceConstants;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction(ITextEditor editor) {
        super(ResourceBundle.getBundle(VjoEditorMessages.BUNDLE_NAME), "TogglePresentation.", null, 2);
        super.setEditor(editor);
        DLTKPluginImages.setToolImageDescriptors((IAction)this, (String)"segment_edit.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, VjetPreferenceConstants.TOGGLE_PRESENTATION_ACTION);
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IRegion remembered = editor.getHighlightRange();
        editor.resetHighlightRange();
        boolean showAll = !editor.showsHighlightRangeOnly();
        this.setChecked(showAll);
        editor.showHighlightRangeOnly(showAll);
        if (remembered != null) {
            editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("com.xore.dltk.ui.editor.showSegments", showAll);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        if (editor instanceof VjoEditor) {
            this.setEnabled(editor != null);
        }
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = VjetUIPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(editor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        boolean showSegments = this.fStore.getBoolean("com.xore.dltk.ui.editor.showSegments");
        this.setChecked(showSegments);
        if (editor.showsHighlightRangeOnly() != showSegments) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            editor.showHighlightRangeOnly(showSegments);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("com.xore.dltk.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

