/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.internal.ui.text.JavascriptCodeScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoFunctionKeywordRule;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoKeywordRule;

public class VjoCodeScanner
extends JavascriptCodeScanner {
    private static String[] fgTokenProperties = new String[]{"DLTK_string", "VJET_regexp_core", "DLTK_keyword"};
    private static final String[] VJO_KEYWORDS = new String[]{String.valueOf(JsCoreKeywords.THIS) + "." + "base", String.valueOf(JsCoreKeywords.THIS) + "." + "vj$" + "." + "parent", String.valueOf(JsCoreKeywords.THIS) + "." + "vj$" + "." + "outer", String.valueOf(JsCoreKeywords.THIS) + "." + VjoCodeScanner.vjo("NEEDS_IMPL")};
    private static final String[] VJO_FUNCTION_COMPOSITE_KEYWORDS = new String[]{VjoCodeScanner.dot("needslib"), VjoCodeScanner.dot("needs"), VjoCodeScanner.vjo("otype"), VjoCodeScanner.vjo("type"), VjoCodeScanner.dot("props"), VjoCodeScanner.dot("protos"), VjoCodeScanner.dot("defs"), VjoCodeScanner.dot("inherits"), VjoCodeScanner.dot("inits"), VjoCodeScanner.dot("satisfies"), VjoCodeScanner.vjo("itype"), VjoCodeScanner.vjo("etype"), VjoCodeScanner.vjo("ltype"), VjoCodeScanner.vjo("mtype"), VjoCodeScanner.vjo("ctype"), VjoCodeScanner.vjo("ftype"), VjoCodeScanner.dot("mixin"), VjoCodeScanner.dot("options"), VjoCodeScanner.dot("globals"), VjoCodeScanner.dot("values"), VjoCodeScanner.dot("endType")};
    private static final List<String> VJO_FUNCTION_KEYWORDS = new ArrayList<String>();
    private List<Point> hightPoints = new ArrayList<Point>();
    private PointComparator pointComparator = new PointComparator();
    private String fContent;
    private ISourceModule m_module;

    static {
        VJO_FUNCTION_KEYWORDS.add("needs");
        VJO_FUNCTION_KEYWORDS.add("globals");
        VJO_FUNCTION_KEYWORDS.add("otype");
        VJO_FUNCTION_KEYWORDS.add("type");
        VJO_FUNCTION_KEYWORDS.add("props");
        VJO_FUNCTION_KEYWORDS.add("protos");
        VJO_FUNCTION_KEYWORDS.add("options");
        VJO_FUNCTION_KEYWORDS.add("defs");
        VJO_FUNCTION_KEYWORDS.add("inherits");
        VJO_FUNCTION_KEYWORDS.add("inits");
        VJO_FUNCTION_KEYWORDS.add("satisfies");
        VJO_FUNCTION_KEYWORDS.add("itype");
        VJO_FUNCTION_KEYWORDS.add("etype");
        VJO_FUNCTION_KEYWORDS.add("ltype");
        VJO_FUNCTION_KEYWORDS.add("mtype");
        VJO_FUNCTION_KEYWORDS.add("ctype");
        VJO_FUNCTION_KEYWORDS.add("ftype");
        VJO_FUNCTION_KEYWORDS.add("makeFinal");
        VJO_FUNCTION_KEYWORDS.add("mixin");
        VJO_FUNCTION_KEYWORDS.add("expects");
        VJO_FUNCTION_KEYWORDS.add("values");
        VJO_FUNCTION_KEYWORDS.add("endType");
        VJO_FUNCTION_KEYWORDS.add("vjo");
    }

    private static String dot(String keyword) {
        return "." + keyword;
    }

    private static String vjo(String keyword) {
        return "vjo." + keyword;
    }

    public void setModule(ISourceModule mModule) {
        this.m_module = mModule;
    }

    public VjoCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
    }

    @Override
    protected String[] getTokenProperties() {
        String[] tokens = super.getTokenProperties();
        String[] newTokens = new String[tokens.length + 4];
        System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
        System.arraycopy(fgTokenProperties, 0, newTokens, tokens.length, fgTokenProperties.length);
        return newTokens;
    }

    @Override
    protected List createRules() {
        List rules = super.createRules();
        Token keyword = this.getToken("DLTK_keyword");
        VjoKeywordRule rule = new VjoKeywordRule(VJO_KEYWORDS, (IToken)keyword);
        rules.add(0, rule);
        rule = new VjoFunctionKeywordRule(VJO_FUNCTION_COMPOSITE_KEYWORDS, (IToken)keyword);
        rules.add(0, rule);
        rules.add(0, new SingleLineRule(VjoCodeScanner.vjo("needs"), "v", (IToken)keyword, '.'));
        Token reg = this.getToken("VJET_regexp_core");
        rules.add(new RegexRule((IToken)reg, '\\'));
        return rules;
    }

    private IDocument getDocument() {
        return this.fDocument;
    }

    public Point[] getHighlightPoints() {
        Point[] result = new Point[this.hightPoints.size()];
        this.hightPoints.toArray(result);
        return result;
    }

    public void setRange(IDocument document, int offset, int length) {
        if (this.documentChanged(document)) {
            this.hightPoints.clear();
            this.initHighLightPoints(document);
        }
        super.setRange(document, offset, length);
    }

    private boolean documentChanged(IDocument document) {
        boolean bol;
        String content = document.get();
        if (this.fContent == null) {
            bol = true;
        } else {
            boolean bl = bol = !this.fContent.equals(content);
        }
        if (bol) {
            this.fContent = content;
        }
        return bol;
    }

    private void initHighLightPoints(IDocument document) {
        IJstType scriptUnit;
        List<JstIdentifier> identifiers;
        JstPackage package1;
        IJstType jstType;
        String content = document.get();
        String groupName = null;
        String typeName = null;
        if (this.m_module instanceof VjoSourceModule) {
            VjoSourceModule module = (VjoSourceModule)this.m_module;
            jstType = module.getJstType();
            if (jstType == null) {
                return;
            }
            package1 = jstType.getPackage();
            if (package1 == null) {
                return;
            }
        } else {
            return;
        }
        groupName = package1.getGroupName();
        typeName = jstType.getName();
        VjoParserToJstAndIType parser = new VjoParserToJstAndIType();
        if (VjetPlugin.TRACE_PARSER) {
            System.out.println("parsing for " + ((Object)((Object)this)).getClass().getName());
        }
        if ((identifiers = this.getJstIdentifierFromScriptUnit(scriptUnit = parser.parse(groupName, typeName, content))).isEmpty()) {
            return;
        }
        for (JstIdentifier identifer : identifiers) {
            JstSource source;
            IJstType t;
            String typename;
            String name = identifer.getName();
            if (!VJO_FUNCTION_KEYWORDS.contains(name)) continue;
            IJstNode node = identifer.getJstBinding();
            if (node instanceof JstMethod) {
                node = ((JstMethod)node).getOwnerType();
            }
            if (node instanceof IJstType && !(typename = (t = (IJstType)node).getName()).startsWith("vjo.") && !typename.equals("vjo") && !typename.equals("type::vjo") || (source = identifer.getSource()) == null) continue;
            this.hightPoints.add(new Point(source.getStartOffSet(), source.getEndOffSet()));
        }
        Collections.sort(this.hightPoints, this.pointComparator);
    }

    private List<JstIdentifier> getJstIdentifierFromScriptUnit(IJstType unit) {
        List blocks = unit.getJstBlockList();
        if (blocks == null) {
            return Collections.emptyList();
        }
        ArrayList<JstIdentifier> result = new ArrayList<JstIdentifier>();
        for (JstBlock block : blocks) {
            this.innerSFindIdentifer((IJstNode)block, result);
        }
        return result;
    }

    private void innerSFindIdentifer(IJstNode node, List<JstIdentifier> result) {
        List nodes;
        JstIdentifier identifer;
        if (node == null) {
            return;
        }
        if (node instanceof JstIdentifier && !result.contains(identifer = (JstIdentifier)node)) {
            result.add(identifer);
        }
        if ((nodes = node.getChildren()).isEmpty()) {
            return;
        }
        for (IJstNode temp : nodes) {
            this.innerSFindIdentifer(temp, result);
        }
    }

    public boolean isValidVjo() {
        return !this.hightPoints.isEmpty();
    }

    class PointComparator
    implements Comparator<Point> {
        PointComparator() {
        }

        @Override
        public int compare(Point object1, Point object2) {
            return object1.x - object2.x;
        }
    }

    class RegexRule
    extends SingleLineRule {
        public RegexRule(IToken token) {
            super("/", "/", token, '\u0000');
        }

        public RegexRule(IToken token, char escapeCharacter) {
            super("/", "/", token, escapeCharacter);
        }

        private IToken evaluateToken(ICharacterScanner scanner) {
            try {
                String token = String.valueOf(VjoCodeScanner.this.getDocument().get(VjoCodeScanner.this.getTokenOffset(), VjoCodeScanner.this.getTokenLength())) + ".";
                int offset = 0;
                char character = token.charAt(++offset);
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                while (character != '/' && offset < token.length() - 1) {
                    character = token.charAt(++offset);
                }
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                if (offset >= 2 && token.charAt(offset) == this.fEndSequence[0]) {
                    int c = scanner.read();
                    if (c != 103 && c != 105) {
                        scanner.unread();
                    } else {
                        int secondChar = scanner.read();
                        if (secondChar != 103 && secondChar != 105 || c == secondChar) {
                            scanner.unread();
                        }
                    }
                    return this.fToken;
                }
            }
            catch (BadLocationException badLocationException) {}
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken result = super.evaluate(scanner);
            if (result == this.fToken) {
                return this.evaluateToken(scanner);
            }
            return result;
        }
    }
}

