/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class VjoKeywordRule
implements IRule {
    private List<String[]> m_keywordParts;
    protected IToken m_token;

    public VjoKeywordRule(String[] keywords, IToken token) {
        this.m_token = token;
        this.initKeywords(keywords);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        for (String[] ss : this.m_keywordParts) {
            IToken token = this.evaluateKeyword(scanner, ss);
            if (token == Token.UNDEFINED) continue;
            return token;
        }
        return Token.UNDEFINED;
    }

    /*
     * Enabled aggressive block sorting
     */
    public IToken evaluateKeyword(ICharacterScanner scanner, String[] m_parts) {
        int pos = 0;
        int partNo = 0;
        StringBuilder buffer = new StringBuilder();
        char c = (char)scanner.read();
        if (m_parts[partNo].charAt(pos) != c) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        ++pos;
        boolean cleanBuffer = false;
        boolean canContinue = true;
        boolean allowWhiteSpaces = false;
        do {
            buffer.append(c);
            c = (char)scanner.read();
            if (pos > m_parts[partNo].length() - 1) {
                pos = 0;
                allowWhiteSpaces = true;
                if (++partNo > m_parts.length - 1) {
                    canContinue = false;
                    break;
                }
            }
            if (m_parts[partNo].charAt(pos) == c) {
                allowWhiteSpaces = false;
                ++pos;
                continue;
            }
            if (allowWhiteSpaces && Character.isWhitespace(c)) continue;
            canContinue = false;
            cleanBuffer = true;
        } while (canContinue);
        scanner.unread();
        if (cleanBuffer) {
            this.unreadBuffer(scanner, buffer.length());
            return Token.UNDEFINED;
        }
        this.preExit(scanner);
        return this.m_token;
    }

    protected void preExit(ICharacterScanner scanner) {
    }

    private void initKeywords(String[] keywords) {
        this.m_keywordParts = new ArrayList<String[]>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            List<String> list = this.initParts(keyword);
            String[] ss = new String[list.size()];
            ss = list.toArray(ss);
            this.m_keywordParts.add(ss);
            ++n2;
        }
    }

    protected List<String> initParts(String word) {
        StringTokenizer tokenizer = new StringTokenizer(word, ".", true);
        ArrayList<String> parts = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            parts.add(token);
        }
        return parts;
    }

    protected void unreadBuffer(ICharacterScanner scanner, int bufferLen) {
        int i = bufferLen - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

