/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;

public abstract class AbstractVariableDeclaration
extends Statement
implements IAbstractVariableDeclaration,
InvocationSite {
    public int declarationEnd;
    public int declarationSourceEnd;
    public int declarationSourceStart;
    public int hiddenVariableDepth;
    public Expression initialization;
    public int modifiers;
    public int modifiersSourceStart;
    public Javadoc javadoc;
    public char[] name;
    public TypeReference type;
    public AbstractVariableDeclaration nextLocal;
    public static final int FIELD = 1;
    public static final int INITIALIZER = 2;
    public static final int LOCAL_VARIABLE = 4;
    public static final int PARAMETER = 5;

    @Override
    public char[] getName() {
        return this.name;
    }

    public abstract int getKind();

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return false;
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        this.printAsExpression(indent, output);
        return output.append(';');
    }

    public StringBuffer printAsExpression(int indent, StringBuffer output) {
        AbstractVariableDeclaration.printIndent(indent, output);
        AbstractVariableDeclaration.printModifiers(this.modifiers, output);
        output.append("var ");
        this.printFragment(indent, output);
        if (this.nextLocal != null) {
            output.append(", ");
            this.nextLocal.printFragment(indent, output);
        }
        return output;
    }

    protected void printFragment(int indent, StringBuffer output) {
        if (this.type != null) {
            this.type.print(0, output).append(' ');
        }
        output.append(this.name);
        if (this.initialization != null) {
            output.append(" = ");
            this.initialization.printExpression(indent, output);
        }
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
        this.hiddenVariableDepth = depth;
    }

    @Override
    public void setFieldIndex(int depth) {
    }

    @Override
    public int getASTType() {
        return 2;
    }

    @Override
    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    @Override
    public IExpression getInitialization() {
        return this.initialization;
    }
}

