/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BalanceUtil {
    private static final int RBRACKET = 54;
    private static final int LBRACKET = 12;
    private static final int RBRACE = 56;
    private static final int LBRACE = 51;
    private static final int RPAREN = 52;
    private static final int LPAREN = 5;
    private static final int VAR = 57;
    private static final int DELETE = 47;
    private static final int CONTINUE = 60;
    private static final int BREAK = 59;
    private static final int RETURN = 65;
    private static final int DOT = 31;
    private static final int COLON = 53;
    private static final int NAMEID = 32;
    private static final int COMMA = 27;
    private static final int CASE = 84;
    private static final int DEFAULT = 85;
    private static final int THIS = 39;
    private static final int EOF = 70;
    private static final int[] LHS_TOKENS = new int[]{5, 51, 12};
    private static final int[] RHS_TOKENS = new int[]{52, 56, 54};
    private static Map<Integer, char[]> LOOKUP = new HashMap<Integer, char[]>();
    private Stack<Tuple> m_termStack = new Stack();
    private List<Tuple> m_tupleInsertList = new ArrayList<Tuple>();
    private List<Tuple> m_tupleRemoveList = new ArrayList<Tuple>();
    private Tuple m_currentTuple = null;
    private Tuple m_currentDotTuple = null;
    private Map<Integer, List<Tuple>> m_tuplesToBeInserted = null;
    private Map<Integer, Tuple> m_tuplesToBeIgnored = null;
    private Tuple m_previousCommaTuple = null;
    private Tuple m_previousColonTuple = null;
    private boolean m_caseTokenEncountered = false;
    private static final Map<Integer, List<Tuple>> EMPTY_INSERT_MAP;
    private static final Map<Integer, Tuple> EMPTY_IGNORE_MAP;

    static {
        LOOKUP.put(5, "(".toCharArray());
        LOOKUP.put(52, ")".toCharArray());
        LOOKUP.put(51, "{".toCharArray());
        LOOKUP.put(56, "}".toCharArray());
        LOOKUP.put(12, "[".toCharArray());
        LOOKUP.put(54, "]".toCharArray());
        LOOKUP.put(59, "break".toCharArray());
        LOOKUP.put(27, ",".toCharArray());
        LOOKUP.put(60, "continue".toCharArray());
        LOOKUP.put(47, "delete".toCharArray());
        LOOKUP.put(31, ".".toCharArray());
        LOOKUP.put(53, ":".toCharArray());
        LOOKUP.put(32, "$missing$".toCharArray());
        LOOKUP.put(65, "return".toCharArray());
        LOOKUP.put(57, "var".toCharArray());
        EMPTY_INSERT_MAP = new HashMap<Integer, List<Tuple>>(0);
        EMPTY_IGNORE_MAP = new HashMap<Integer, Tuple>(0);
    }

    public static char[] getTokenSource(int token) {
        return LOOKUP.get(token);
    }

    public static char getTokenChar(int token) {
        return BalanceUtil.getTokenSource(token)[0];
    }

    public BalanceUtil addToken(int token, int location) {
        if (token == 31) {
            this.m_currentDotTuple = new Tuple(token, location);
        } else if (this.m_currentDotTuple != null) {
            if (token == 27 || token == 54 || token == 70) {
                this.m_tupleInsertList.add(new Tuple(32, this.m_currentDotTuple.m_location, 31));
            } else if (token == 52 || token == 56 || token == 57 || token == 39 || token == 65 || token == 59 || token == 60 || token == 47) {
                this.m_tupleInsertList.add(new Tuple(32, this.m_currentDotTuple.m_location, 31));
                if (!this.m_termStack.isEmpty()) {
                    int tok = this.m_termStack.peek().m_token;
                    if (tok == 5 && token != 52) {
                        this.m_tupleInsertList.add(new Tuple(52, this.m_currentDotTuple.m_location));
                    } else if (tok == 12) {
                        this.m_tupleInsertList.add(new Tuple(54, this.m_currentDotTuple.m_location));
                    }
                }
            }
            this.m_currentDotTuple = null;
        }
        if (this.m_previousCommaTuple != null && (token == 56 || token == 52 || token == 56)) {
            this.m_tupleRemoveList.add(this.m_previousCommaTuple);
        }
        if (this.m_previousColonTuple != null && token == 56) {
            this.m_tupleInsertList.add(new Tuple(32, this.m_previousColonTuple.m_location, 53));
        }
        this.m_previousCommaTuple = token == 27 ? new Tuple(token, location) : null;
        if (token == 84 || token == 85) {
            this.m_caseTokenEncountered = true;
        }
        if (token == 53) {
            if (this.m_caseTokenEncountered) {
                this.m_caseTokenEncountered = false;
            } else {
                this.m_previousColonTuple = new Tuple(token, location);
            }
        } else {
            this.m_previousColonTuple = null;
        }
        if (!this.isGroupingToken(token)) {
            return this;
        }
        if (this.m_currentTuple != null && this.m_currentTuple.m_location == location && this.m_currentTuple.m_token == token) {
            return this;
        }
        if (token == 70) {
            return this;
        }
        this.m_currentTuple = new Tuple(token, location);
        if (BalanceUtil.isLHToken(token)) {
            this.m_termStack.add(this.m_currentTuple);
        } else {
            int token2;
            if (this.m_termStack.size() > 0 && BalanceUtil.isLHToken(token2 = this.m_termStack.peek().m_token) && BalanceUtil.matching(token2, token)) {
                this.m_termStack.pop();
                return this;
            }
            this.m_termStack.add(this.m_currentTuple);
        }
        return this;
    }

    private boolean isGroupingToken(int token) {
        int t;
        if (this.m_currentTuple != null && this.m_currentTuple.m_token == 70) {
            return false;
        }
        int[] nArray = LHS_TOKENS;
        int n = LHS_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            t = nArray[n2];
            if (token == t) {
                return true;
            }
            ++n2;
        }
        nArray = RHS_TOKENS;
        n = RHS_TOKENS.length;
        n2 = 0;
        while (n2 < n) {
            t = nArray[n2];
            if (token == t) {
                return true;
            }
            ++n2;
        }
        return token == 70;
    }

    public Map<Integer, List<Tuple>> getTuplesToBeInserted() {
        if (this.m_tuplesToBeInserted != null) {
            return this.m_tuplesToBeInserted;
        }
        if (this.m_tupleInsertList.isEmpty()) {
            this.m_tuplesToBeInserted = EMPTY_INSERT_MAP;
            return this.m_tuplesToBeInserted;
        }
        this.m_tuplesToBeInserted = new LinkedHashMap<Integer, List<Tuple>>();
        for (Tuple t : this.m_tupleInsertList) {
            List<Tuple> list = this.m_tuplesToBeInserted.get(t.m_location);
            if (list == null) {
                list = new ArrayList<Tuple>();
                this.m_tuplesToBeInserted.put(t.m_location, list);
            }
            list.add(t);
        }
        return this.m_tuplesToBeInserted;
    }

    public Map<Integer, Tuple> getTuplesToBeIgnored() {
        if (this.m_tuplesToBeIgnored != null) {
            return this.m_tuplesToBeIgnored;
        }
        if (this.m_tupleRemoveList.isEmpty()) {
            this.m_tuplesToBeIgnored = EMPTY_IGNORE_MAP;
            return this.m_tuplesToBeIgnored;
        }
        this.m_tuplesToBeIgnored = new HashMap<Integer, Tuple>();
        for (Tuple tuple : this.m_tupleRemoveList) {
            this.m_tuplesToBeIgnored.put(tuple.m_location, tuple);
        }
        return this.m_tuplesToBeIgnored;
    }

    public String toString() {
        return this.m_tupleInsertList.toString();
    }

    private static boolean matching(int left, int right) {
        if (left == 5 && right == 52) {
            return true;
        }
        if (left == 51 && right == 56) {
            return true;
        }
        return left == 12 && right == 54;
    }

    private static boolean isLHToken(int token) {
        int[] nArray = LHS_TOKENS;
        int n = LHS_TOKENS.length;
        int n2 = 0;
        while (n2 < n) {
            int token2 = nArray[n2];
            if (token2 == token) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void main(String[] args) {
        BalanceUtil butil = new BalanceUtil().addToken(5, 4).addToken(32, 13).addToken(31, 14).addToken(56, 21);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(12, 4).addToken(32, 13).addToken(31, 14).addToken(56, 21);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(32, 13).addToken(31, 14).addToken(56, 15);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(32, 13).addToken(31, 14).addToken(27, 15);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(32, 13).addToken(31, 14).addToken(54, 15);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(5, 12).addToken(32, 13).addToken(31, 14).addToken(39, 16);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(12, 12).addToken(32, 13).addToken(31, 14).addToken(39, 16);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(32, 13).addToken(31, 14).addToken(39, 16);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(5, 4).addToken(31, 13).addToken(57, 14);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(12, 13).addToken(32, 13).addToken(31, 14).addToken(57, 16);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
        butil = new BalanceUtil().addToken(32, 13).addToken(31, 14).addToken(57, 16);
        System.out.println("BALANCE = " + butil.getTuplesToBeInserted());
    }

    public static class Tuple {
        int m_token;
        int m_location;
        int m_previousToken = -1;

        public Tuple(int token, int loc) {
            this.m_token = token;
            this.m_location = loc;
        }

        public Tuple(int token, int loc, int previousToken) {
            this.m_token = token;
            this.m_location = loc;
            this.m_previousToken = previousToken;
        }

        public String toString() {
            return String.valueOf(this.m_token) + " " + new String((char[])LOOKUP.get(this.m_token)) + " " + this.m_location;
        }
    }
}

