/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.dom;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.javatojs.anno.ARename;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.BaseCustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.IPrivilegedProcessor;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.PrivilegedProcessorAdapter;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.anno.Alias;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.anno.Constructor;
import org.eclipse.vjet.dsf.jsnative.anno.Function;
import org.eclipse.vjet.dsf.jsnative.anno.GlobalProperty;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jsnative.anno.OverLoadFunc;
import org.eclipse.vjet.dsf.jsnative.anno.Property;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.mozilla.mod.javascript.Scriptable;

public class ADomMeta
extends BaseCustomMetaProvider
implements ICustomMetaProvider {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final char ARG_SEPERATOR = '#';
    private static List<String> s_jsNativeSpecialProps = new ArrayList<String>();
    private boolean m_lookupMtdBySigniture = false;
    private static List<String> m_jsNativeSpecialProps = new ArrayList<String>();

    static {
        m_jsNativeSpecialProps.add("NaN");
        m_jsNativeSpecialProps.add("Infinity");
        m_jsNativeSpecialProps.add("URLUnencoded");
    }

    public ADomMeta() {
        this(false);
    }

    public ADomMeta(boolean lookupMtdBySigniture) {
        this.m_lookupMtdBySigniture = lookupMtdBySigniture;
        this.init();
    }

    private void init() {
        s_jsNativeSpecialProps.add("NaN");
        s_jsNativeSpecialProps.add("Infinity");
        for (Class c : JsNativeMeta.getAllClasses()) {
            this.add(c);
        }
        this.loadWindowCustomMeta();
        this.loadAHtmlDocument();
        this.loadHtmlElementMeta();
        this.loadJsNativeNodeMeta();
        Class<DsfEvent> type = DsfEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = BrowserType.class;
        CustomType cType = new CustomType(type, type.getSimpleName());
        this.addCustomType(type.getName(), cType);
        this.addCustomType(type.getSimpleName(), cType);
    }

    private void loadWindowCustomMeta() {
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.jsnative.Window", "newImage", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr[] argArr;
                if (args != null) {
                    argArr = new IExpr[args.size()];
                    args.toArray(argArr);
                } else {
                    argArr = new IExpr[]{};
                }
                return TranslateHelper.Expression.createObjCreationExpr((String)"Image", (IExpr[])argArr);
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.jsnative.Window", "newOption", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr[] argArr;
                if (args != null) {
                    argArr = new IExpr[args.size()];
                    args.toArray(argArr);
                } else {
                    argArr = new IExpr[]{};
                }
                return TranslateHelper.Expression.createObjCreationExpr((String)"Option", (IExpr[])argArr);
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.jsnative.Window", "newXmlHttpReq", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                return new TextExpr("window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject('MSXML2.XMLHTTP')");
            }
        });
    }

    private void loadJsNativeNodeMeta() {
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.jsnative.Node", "addt", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                JstIdentifier myidentifier = new JstIdentifier("createTextNode", new JstIdentifier("document"));
                MtdInvocationExpr createMtdExpr = new MtdInvocationExpr(myidentifier, new IExpr[0]);
                createMtdExpr.addArg(args.get(0));
                identifier.setName("appendChild");
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                mtdCall.setQualifyExpr(optionalExpr);
                mtdCall.addArg((IExpr)createMtdExpr);
                return mtdCall;
            }
        });
    }

    private void loadHtmlElementMeta() {
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.jsnative.HtmlElement", "addBr", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                JstIdentifier myidentifier = new JstIdentifier("createElement", new JstIdentifier("document"));
                MtdInvocationExpr createMtdExpr = new MtdInvocationExpr(myidentifier, new IExpr[0]);
                TextExpr br = new TextExpr("'br'");
                createMtdExpr.addArg((IExpr)br);
                identifier.setName("appendChild");
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                mtdCall.setQualifyExpr(optionalExpr);
                mtdCall.addArg((IExpr)createMtdExpr);
                return mtdCall;
            }
        });
    }

    private void loadAHtmlDocument() {
        Class<HtmlDocument> type = HtmlDocument.class;
        CustomType customType = this.createCustomType(type, this.getProperties(HtmlDocument.class), this.getFunctions(HtmlDocument.class));
        this.addCustomType(type.getName(), customType);
    }

    private void add(Class type) {
        CustomType customType = this.createCustomType(type, this.getProperties(type), this.getFunctions(type)).setAttr(CustomAttr.MAPPED_TO_JS);
        this.addCustomType(type.getName(), customType);
        Alias alias = type.getAnnotation(Alias.class);
        if (alias != null) {
            this.addCustomType(alias.value(), customType);
        }
    }

    private Map<String, String> getFunctions(Class type) {
        HashMap<String, String> funcs = new HashMap<String, String>();
        Method[] mtds = type.getMethods();
        String mtdJsNative = null;
        Method[] methodArray = mtds;
        int n = mtds.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!m.getDeclaringClass().equals(Scriptable.class) && Modifier.isPublic(m.getModifiers())) {
                Annotation[] annotations;
                String mtdName = m.getName();
                if (this.lookupMtdBySigniture()) {
                    Class<?>[] classArray = m.getParameterTypes();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> c = classArray[n4];
                        mtdName = String.valueOf(mtdName) + '#' + c.getName();
                        ++n4;
                    }
                }
                mtdJsNative = null;
                boolean isFunction = false;
                Annotation[] annotationArray = annotations = m.getAnnotations();
                int n5 = annotations.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation annot = annotationArray[n6];
                    if (annot.annotationType().equals(Property.class)) break;
                    if (annot.annotationType().equals(Function.class) || annot.annotationType().equals(OverLoadFunc.class) || annot.annotationType().equals(Constructor.class)) {
                        isFunction = true;
                    } else if (annot.annotationType().equals(ARename.class)) {
                        ARename rename = (ARename)annot;
                        mtdJsNative = rename.name();
                    }
                    ++n6;
                }
                if (isFunction && !funcs.containsKey(mtdName)) {
                    funcs.put(mtdName, mtdJsNative);
                }
            }
            ++n2;
        }
        return funcs;
    }

    private Map<String, String> getProperties(Class type) {
        HashMap<String, String> props = new HashMap<String, String>();
        Method[] mtds = type.getMethods();
        String jsNativeName = null;
        Method[] methodArray = mtds;
        int n = mtds.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!m.getDeclaringClass().equals(Scriptable.class) && Modifier.isPublic(m.getModifiers())) {
                Annotation[] annotations;
                String mtdName = m.getName();
                if (this.lookupMtdBySigniture()) {
                    Class<?>[] classArray = m.getParameterTypes();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> c = classArray[n4];
                        mtdName = String.valueOf(mtdName) + '#' + c.getName();
                        ++n4;
                    }
                }
                jsNativeName = null;
                boolean isProperty = false;
                Annotation[] annotationArray = annotations = m.getAnnotations();
                int n5 = annotations.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation annot = annotationArray[n6];
                    if (annot.annotationType().equals(Property.class) || annot.annotationType().equals(GlobalProperty.class)) {
                        isProperty = true;
                    } else if (annot.annotationType().equals(ARename.class)) {
                        ARename rename = (ARename)annot;
                        jsNativeName = rename.name();
                    }
                    ++n6;
                }
                if (isProperty && !props.containsKey(mtdName)) {
                    props.put(mtdName, jsNativeName);
                }
            }
            ++n2;
        }
        return props;
    }

    private CustomType createCustomType(Class javaType, Map<String, String> ptys, Map<String, String> funcs) {
        MethodKey key;
        String jstMtdName;
        String jstOrigMtdName;
        String javaMtdName;
        int indx;
        CustomType cType = new CustomType(javaType, javaType.getName());
        if (ptys != null) {
            for (String pty : ptys.keySet()) {
                if (pty.length() == 0) continue;
                String ptyName = pty;
                indx = ptyName.indexOf(35);
                if (indx != -1) {
                    ptyName = ptyName.substring(0, indx);
                }
                javaMtdName = ptyName;
                jstOrigMtdName = this.getOriginalPropertyName(javaType, ptyName);
                jstMtdName = ptys.get(pty);
                if (jstMtdName == null) {
                    jstMtdName = jstOrigMtdName;
                }
                key = indx != -1 ? new MethodKey(javaMtdName, false, new String[]{pty.substring(indx + 1)}) : new MethodKey(javaMtdName);
                cType.addCustomMethod(new CustomMethod(key, jstMtdName).setJstOrigName(jstOrigMtdName).setIsProperty(true).setLookupBySignature(this.lookupMtdBySigniture()));
            }
        }
        if (funcs != null) {
            for (String f : funcs.keySet()) {
                jstMtdName = funcs.get(f);
                javaMtdName = f;
                indx = javaMtdName.indexOf(35);
                if (indx != -1) {
                    javaMtdName = javaMtdName.substring(0, indx);
                }
                jstOrigMtdName = javaMtdName;
                if (jstMtdName == null) {
                    jstMtdName = jstOrigMtdName;
                }
                key = indx != -1 ? new MethodKey(javaMtdName, false, new String[]{f.substring(indx + 1)}) : new MethodKey(javaMtdName);
                cType.addCustomMethod(new CustomMethod(key, jstMtdName).setJstOrigName(jstOrigMtdName).setLookupBySignature(this.lookupMtdBySigniture()));
            }
        }
        return cType;
    }

    private String getOriginalPropertyName(Class javaType, String ptyName) {
        boolean isGetOrSet;
        boolean bl = isGetOrSet = ptyName.startsWith(GET) || ptyName.startsWith(SET);
        if (!isGetOrSet) {
            return ptyName;
        }
        String propName = null;
        try {
            Method mtd;
            Property p;
            Class[] parameterTypes = null;
            if (ptyName.startsWith(SET)) {
                parameterTypes = new Class[]{Object.class};
            }
            if ((p = (mtd = javaType.getMethod(ptyName, parameterTypes)).getAnnotation(Property.class)) != null && p.name() != null && p.name().length() > 0) {
                propName = p.name();
            }
        }
        catch (Exception exception) {}
        if (propName == null) {
            propName = this.getOriginalPropertyName(ptyName.substring(3));
        }
        return propName;
    }

    private String getOriginalPropertyName(String propName) {
        if (m_jsNativeSpecialProps.contains(propName)) {
            return propName;
        }
        if (this.isNameAllCapitalized(propName)) {
            return propName;
        }
        return String.valueOf(propName.substring(0, 1).toLowerCase()) + propName.substring(1);
    }

    private boolean isNameAllCapitalized(String name) {
        char[] chars;
        char[] cArray = chars = name.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean lookupMtdBySigniture() {
        return this.m_lookupMtdBySigniture;
    }
}

