/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResult;
import org.eclipse.vjet.dsf.liveconnect.DLCPageHistory;
import org.eclipse.vjet.dsf.liveconnect.DLCServer;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcher;
import org.eclipse.vjet.dsf.liveconnect.IDLCDispatcherInfoCollector;

public class DLCDispatcher
implements IDLCDispatcher {
    private DLCServer m_dlcServer;
    private Set<SocketChannel> m_channels = new LinkedHashSet<SocketChannel>();
    private Map<String, DLCPageHistory> m_histories = new HashMap<String, DLCPageHistory>();
    private IDLCDispatcherInfoCollector m_infoCollector;
    private static final String NULL = "null";

    public DLCDispatcher(DLCServer dlcServer) {
        this.m_dlcServer = dlcServer;
    }

    public synchronized void send(SocketChannel channel, String data) {
        if (this.m_infoCollector != null) {
            this.m_infoCollector.send(data);
        }
        this.m_dlcServer.send(channel, data);
    }

    @Override
    public synchronized void send(String data) {
        if (this.m_channels.isEmpty()) {
            return;
        }
        SocketChannel channel = this.m_channels.iterator().next();
        this.send(channel, data);
    }

    public synchronized void broadcast(String data, SocketChannel exclude) {
        if (this.m_channels.isEmpty()) {
            System.err.println("There is no established channel");
        }
        for (SocketChannel channel : this.m_channels) {
            if (channel == exclude) continue;
            this.m_dlcServer.send(channel, data);
        }
    }

    @Override
    public String request(String message, int timeoutInMilli) {
        if (this.m_channels.isEmpty()) {
            return null;
        }
        SocketChannel channel = this.m_channels.iterator().next();
        return this.request(channel, message, timeoutInMilli);
    }

    public String request(SocketChannel channel, String message, int timeoutInMilli) {
        if (this.m_infoCollector != null) {
            this.m_infoCollector.request(message);
        }
        DLCFutureResult response = this.m_dlcServer.request(channel, message);
        String result = response.get(timeoutInMilli, TimeUnit.MILLISECONDS);
        if (this.m_infoCollector != null) {
            this.m_infoCollector.response(result);
        }
        if (NULL.equals(result)) {
            return null;
        }
        return result;
    }

    public synchronized void addChannel(SocketChannel channel) {
        this.m_channels.add(channel);
    }

    public synchronized boolean removeChannel(SocketChannel channel) {
        return this.m_channels.remove(channel);
    }

    public Iterator<SocketChannel> getChannels() {
        return this.m_channels.iterator();
    }

    public boolean hasChannel() {
        return !this.m_channels.isEmpty();
    }

    public void shutdownDlcServer() {
        this.m_channels.clear();
        this.m_dlcServer.shutdown();
    }

    public int getDlcServerPort() {
        return this.m_dlcServer.getPort();
    }

    public boolean isNewSession(String sessionId) {
        return !this.m_histories.containsKey(sessionId);
    }

    public synchronized String add(String sessionId, String location) {
        DLCPageHistory history = this.m_histories.get(sessionId);
        if (history == null) {
            history = new DLCPageHistory();
            this.m_histories.put(sessionId, history);
        }
        return history.add(location);
    }

    public synchronized String getCurrentLocation() {
        if (this.m_histories.isEmpty()) {
            return null;
        }
        return this.m_histories.values().iterator().next().getCurrentLocation();
    }

    public void setInfoCollector(IDLCDispatcherInfoCollector infoCollector) {
        this.m_infoCollector = infoCollector;
    }
}

