/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DLCHttpRequest {
    private static final String GET = "GET /";
    private static final String HTTP = " HTTP/";
    private Map<String, String> m_headers = new LinkedHashMap<String, String>();
    private String m_message = null;
    private String m_uri = null;
    private static final String HEADER_TOKEN = "\r\n";
    private static final String END_HEADER_TOKEN = "\r\n\r\n";

    public String getHeader(String name) {
        return this.m_headers.get(name);
    }

    public Iterator<String> getHeaderNames() {
        return this.m_headers.keySet().iterator();
    }

    public String getMessage() {
        return this.m_message;
    }

    public String getUri() {
        return this.m_uri;
    }

    public DLCHttpRequest(String requestData) {
        if (requestData.startsWith(GET)) {
            this.m_uri = requestData.substring(GET.length(), requestData.indexOf(HTTP));
        }
        int start = requestData.indexOf(HEADER_TOKEN);
        int endOfHeader = requestData.indexOf(END_HEADER_TOKEN);
        if (start == -1) {
            throw new RuntimeException("Incorrect HTTP request");
        }
        int end = requestData.indexOf(HEADER_TOKEN, start += HEADER_TOKEN.length());
        while (end > 0 && end <= endOfHeader) {
            String line = requestData.substring(start, end);
            this.processHeader(line);
            if (end < endOfHeader) {
                start = end + HEADER_TOKEN.length();
                end = requestData.indexOf(HEADER_TOKEN, start);
                continue;
            }
            start = end + END_HEADER_TOKEN.length();
            end = -1;
        }
        if (start < requestData.length()) {
            this.m_message = requestData.substring(start);
        }
    }

    private void processHeader(String line) {
        int index = line.indexOf(":");
        if (index == -1) {
            return;
        }
        String name = line.substring(0, index).trim();
        String value = line.substring(index + 1).trim();
        this.m_headers.put(name, value);
    }
}

