/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.event.export;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.DsfEventTarget;
import org.eclipse.vjet.dsf.html.events.EventHandlerContainer;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;
import org.eclipse.vjet.dsf.html.js.IScopeableJsHandler;
import org.eclipse.vjet.dsf.html.js.JsFunctionEventHandlerAdaptor;
import org.eclipse.vjet.vsf.jsruntime.compregistry.JsComponentRegistry;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.optimizer.JsFuncCodeGenOptimizer;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsObjHandler;

public final class EventDispatcherEnabler {
    private static final String NEW_LINE = System.getProperty("line.separator");
    public static final String EVENT_DISPATCHER = "vjo.dsf.EventDispatcher";
    public static final String EVENT_DISPATCHER_SHORT = "_d";
    private HashSet<IDomEventType> m_enabledEvents = new HashSet();

    void enableEvent(IDomEventType eventType) {
        this.m_enabledEvents.add(eventType);
    }

    void addEventTrigger(DElement element, IDomEventType eventType) {
        String eventName = eventType.getName();
        String eventAttribute = "on" + eventName;
        element.setAttribute(eventAttribute, EventDispatcherEnabler.getDispatchWithNativeEvent(eventName));
    }

    void addOnLoadEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onload", EventDispatcherEnabler.getDispatch("load"));
    }

    void addOnUnloadEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onunload", EventDispatcherEnabler.getDispatch("unload"));
    }

    void addOnChangeEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onchange", EventDispatcherEnabler.getDispatch("change"));
    }

    void addOnSubmitEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onsubmit", EventDispatcherEnabler.getDispatch("submit"));
    }

    void addOnResetEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onreset", EventDispatcherEnabler.getDispatch("reset"));
    }

    void addOnSelectEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onselect", EventDispatcherEnabler.getDispatch("select"));
    }

    void addOnBlurEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onblur", EventDispatcherEnabler.getDispatch("blur"));
    }

    void addOnFocusEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onfocus", EventDispatcherEnabler.getDispatch("focus"));
    }

    void addOnKeyDownEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onkeydown", EventDispatcherEnabler.getDispatch("keydown"));
    }

    void addOnKeyPressEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onkeypress", EventDispatcherEnabler.getDispatch("keypress"));
    }

    void addOnKeyUpEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onkeyup", EventDispatcherEnabler.getDispatch("keyup"));
    }

    void addOnClickEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onclick", EventDispatcherEnabler.getDispatch("click"));
    }

    void addOnDblClickEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("ondblclick", EventDispatcherEnabler.getDispatch("dblclick"));
    }

    void addOnMouseDownEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onmousedown", EventDispatcherEnabler.getDispatch("mousedown"));
    }

    void addOnMouseMoveEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onmousemove", EventDispatcherEnabler.getDispatch("mousemove"));
    }

    void addOnMouseOutEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onmouseout", EventDispatcherEnabler.getDispatch("mouseout"));
    }

    void addOnMouseOverEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onmouseover", EventDispatcherEnabler.getDispatch("mouseover"));
    }

    void addOnMouseUpEventTrigger(BaseAttrsHtmlElement element) {
        element.setAttribute("onmouseup", EventDispatcherEnabler.getDispatch("mouseup"));
    }

    public static String extractEventHandlerData(EventHandlerContainer container, boolean optimize) {
        StringBuilder jsDef = new StringBuilder();
        if (optimize) {
            JsRuntimeCtx.ctx().getCompRegistry().setRegistryVar("_r");
        }
        JsFuncCodeGenOptimizer optimizer = optimize ? new JsFuncCodeGenOptimizer() : null;
        EventDispatcherEnabler.extractHandlerDefData(container.getElements(), jsDef, optimizer);
        EventDispatcherEnabler.extractHandlerDefData(container.getElementsAttached(), jsDef, optimizer);
        StringBuilder jsReg = new StringBuilder();
        jsReg.append("(function(){").append(NEW_LINE).append("var ").append(EVENT_DISPATCHER_SHORT).append("=").append(EVENT_DISPATCHER).append(";").append(NEW_LINE).append("var ").append("_r").append("=").append("vjo.Registry").append(";").append(NEW_LINE);
        if (optimize) {
            jsReg.append(optimizer.createDefs());
        }
        jsReg.append((CharSequence)jsDef);
        EventDispatcherEnabler.extractHandlerRegData(container.getElements(), jsReg, optimizer);
        EventDispatcherEnabler.extractHandlerRegData(container.getElementsAttached(), jsReg, optimizer);
        jsReg.append("})();");
        if (optimize) {
            JsRuntimeCtx.ctx().getCompRegistry().resetRegistryVar();
        }
        return jsReg.toString();
    }

    private static void extractHandlerDefData(Map<DsfEventTarget, List<EventHandlerContainer.EventsToHandlerPair>> elemMap, StringBuilder jsContent, JsFuncCodeGenOptimizer optimizer) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<DsfEventTarget, List<EventHandlerContainer.EventsToHandlerPair>> entry : elemMap.entrySet()) {
            for (EventHandlerContainer.EventsToHandlerPair pair : entry.getValue()) {
                String def;
                ISimpleJsEventHandler handler = pair.getHandler();
                if (optimizer != null && handler instanceof JsFunctionEventHandlerAdaptor) {
                    JsFunctionEventHandlerAdaptor new_handler = (JsFunctionEventHandlerAdaptor)pair.getHandler();
                    optimizer.add((Object)new_handler.getJsFunc());
                }
                if ((def = handler.asJsDefinition()) == null || "".equals(def) || set.contains(def)) continue;
                jsContent.append(def).append(" ");
                set.add(def);
            }
        }
    }

    private static String generateEventHandler(ISimpleJsEventHandler handler, JsFuncCodeGenOptimizer optimizer) {
        if (handler instanceof JsFunctionEventHandlerAdaptor) {
            JsFunctionEventHandlerAdaptor oHandler = (JsFunctionEventHandlerAdaptor)handler;
            return optimizer.createCall((Object)oHandler.getJsFunc());
        }
        return "";
    }

    private static void extractHandlerRegData(Map<DsfEventTarget, List<EventHandlerContainer.EventsToHandlerPair>> elemMap, StringBuilder jsContent, JsFuncCodeGenOptimizer optimizer) {
        int i = 0;
        for (Map.Entry<DsfEventTarget, List<EventHandlerContainer.EventsToHandlerPair>> entry : elemMap.entrySet()) {
            DsfEventTarget target = entry.getKey();
            if (HtmlTypeEnum.BODY.equals((Object)target.getType()) || target.getElem() instanceof DBody) {
                target.setId("body");
            }
            boolean byId = target.getId() != null;
            String srcId = byId ? target.getId() : target.getElem().getAttribute("id");
            for (EventHandlerContainer.EventsToHandlerPair pair : entry.getValue()) {
                ISimpleJsEventHandler handler = pair.getHandler();
                IDomEventType type = pair.getEventType();
                String instanceStr = optimizer == null ? null : EventDispatcherEnabler.generateEventHandler(handler, optimizer);
                instanceStr = instanceStr == null || "".equals(instanceStr) ? EventDispatcherEnabler.generateHandler(jsContent, handler) : instanceStr;
                String method = byId || !JsRuntimeCtx.ctx().useInlineEventBinding() ? "add" : "register";
                jsContent.append(EVENT_DISPATCHER_SHORT).append(".").append(method).append("('").append(srcId).append("','").append(type.getName()).append("',").append(instanceStr);
                if (handler instanceof IScopeableJsHandler) {
                    String scope = ((IScopeableJsHandler)handler).getScope();
                    jsContent.append(",").append(scope);
                }
                jsContent.append(");");
                if (++i % 10 != 0) continue;
                jsContent.append(NEW_LINE);
            }
        }
    }

    private static String generateHandler(StringBuilder jsContent, ISimpleJsEventHandler handler) {
        IJsObjectRef oRef = null;
        if (handler instanceof IJsObjHandler) {
            oRef = ((IJsObjHandler)handler).getJsObj();
        }
        String instanceStr = "";
        if (oRef != null) {
            if (jsContent != null && oRef.isHandler() && !oRef.isGenned()) {
                jsContent.append(oRef.generate(true)).append(NEW_LINE);
            }
            instanceStr = JsComponentRegistry.getJsInstance((String)oRef.getInstanceId(), (boolean)true);
        } else {
            instanceStr = handler instanceof IScopeableJsHandler ? ((IScopeableJsHandler)handler).asJsHandler("this") : handler.asJsHandler();
        }
        return instanceStr;
    }

    @Deprecated
    public static void addHandlerRegistration(String srcId, IDomEventType type, ISimpleJsEventHandler handler, StringBuilder jsContent, boolean byId, boolean optimize) {
        if (jsContent == null) {
            return;
        }
        String method = byId || !JsRuntimeCtx.ctx().useInlineEventBinding() ? "add" : "register";
        IJsObjectRef oRef = null;
        if (handler instanceof IJsObjHandler) {
            oRef = ((IJsObjHandler)handler).getJsObj();
        }
        String instanceStr = "";
        if (oRef != null) {
            if (oRef.isHandler() && !oRef.isGenned()) {
                jsContent.append(oRef.generate(true)).append(NEW_LINE);
            }
            instanceStr = JsComponentRegistry.getJsInstance((String)oRef.getInstanceId(), (boolean)true);
        } else {
            instanceStr = handler.asJsHandler();
        }
        jsContent.append(optimize ? EVENT_DISPATCHER_SHORT : EVENT_DISPATCHER).append(".").append(method).append("('").append(srcId).append("','").append(type.getName()).append("',").append(instanceStr).append(");").append(NEW_LINE);
    }

    private static String getDispatch(String event) {
        return "return vjo.dsf.EventDispatcher.run(this,null,'" + event + "')";
    }

    private static String getDispatchWithNativeEvent(String event) {
        return "return vjo.dsf.EventDispatcher.run(this,event,'" + event + "')";
    }
}

