/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.js;

import java.util.List;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlot;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.vsf.docprocessing.IJsResourceApplier;
import org.eclipse.vjet.vsf.jsruntime.JsRuntimeVersion;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.w3c.dom.Node;

public class JsResourceApplier
implements IJsResourceApplier {
    public static JsResourceApplier DEFAULT = new JsResourceApplier();
    protected String m_jsRtVersion = null;

    public void apply(DDocument doc, JsResourceSlotter slotter, boolean applyScope) {
        this.apply((DHtmlDocument)doc, slotter, applyScope);
    }

    public void apply(DHtmlDocument doc, JsResourceSlotter slotter, boolean applyScope) {
        if (applyScope) {
            this.initVersionScope(doc, slotter);
        }
        Permutation permutation = Permutation.getFromCtx();
        DBody body = doc.getBody();
        Node firstChild = body.getFirstChild();
        for (JsResourceSlot slot : slotter.getAllSlots()) {
            Node childRefToInsertBefore = null;
            if (slot.getName().startsWith("BEFORE")) {
                childRefToInsertBefore = firstChild;
            }
            this.addSlotToElement(slot, permutation, (DElement)body, childRefToInsertBefore);
        }
    }

    public void initVersionScope(DHtmlDocument doc, JsResourceSlotter slotter) {
        this.m_jsRtVersion = slotter.getRuntimeVersion();
        if (this.m_jsRtVersion == null) {
            return;
        }
        DScript script = new DScript().setHtmlType("text/javascript").setHtmlText(JsRuntimeVersion.getVersionScopeInit((String)this.m_jsRtVersion));
        doc.getHead().add((DNode)script);
    }

    public void addSlotToElement(JsResourceSlot slot, Permutation permutation, DElement parent, Node childRefToInsertBefore) {
        String scriptTextString;
        List refs = slot.getResourceRefs();
        if (refs.size() <= 0) {
            return;
        }
        boolean verboseOn = TraceCtx.ctx().getTraceManager().isVerboseOn();
        if (verboseOn) {
            DComment beginComment = new DComment(" begin " + slot.getName());
            parent.insertBefore((Node)beginComment, childRefToInsertBefore);
        }
        StringBuilder scriptText = new StringBuilder();
        for (IJsResourceRef ref : refs) {
            IJsResourceHandle handle = ref.getHandle(permutation);
            if (handle.isExternalized()) {
                DScript script;
                if (this.m_jsRtVersion != null) {
                    script = new DScript().setHtmlType("text/javascript").setHtmlText(JsRuntimeVersion.getExternalFileScope((String)this.m_jsRtVersion));
                    parent.insertBefore((Node)script, childRefToInsertBefore);
                }
                script = new DScript().setHtmlType("text/javascript").setHtmlSrc(handle.getExternalUrl().toExternalForm());
                parent.insertBefore((Node)script, childRefToInsertBefore);
                continue;
            }
            scriptText.append(ref.getHandle(permutation).getScriptText());
            scriptText.append("\n");
        }
        if (this.m_jsRtVersion != null && scriptText.length() > 0) {
            scriptText.insert(0, JsRuntimeVersion.getVersionScopeStart((String)this.m_jsRtVersion));
            scriptText.append(JsRuntimeVersion.getVersionScopeEnd((String)this.m_jsRtVersion));
        }
        if ((scriptTextString = scriptText.toString()) != null && scriptTextString.trim().length() > 0) {
            DScript script = new DScript().setHtmlType("text/javascript").setHtmlText(scriptTextString);
            parent.insertBefore((Node)script, childRefToInsertBefore);
        }
        if (verboseOn) {
            DComment endComment = new DComment("end " + slot.getName());
            parent.insertBefore((Node)endComment, childRefToInsertBefore);
        }
    }
}

