/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class BooleanConverter
extends BaseConverter<Boolean> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String.class, Integer.class, Long.class, Boolean.class};
        VALID_CONVERSION_TYPES = BooleanConverter.immutableTypeList(types);
    }

    @Override
    public Class<Boolean> getTargetType() {
        return Boolean.class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Boolean> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Boolean value = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String.class) {
                if (preValue.toString().length() == 0 && this.isEmptyStringTreatedAsNull()) {
                    return this.setResult(preValue, null);
                }
                if (preValue.toString().equalsIgnoreCase("true")) {
                    return this.setResult(preValue, Boolean.TRUE);
                }
                if (preValue.toString().equalsIgnoreCase("false")) {
                    return this.setResult(preValue, Boolean.FALSE);
                }
                Integer v = this.getValueAsInteger((String)preValue);
                value = v != null && v > 0 ? Boolean.TRUE : Boolean.FALSE;
                return this.setResult(preValue, value);
            }
            if (clz == Integer.class) {
                Integer v = (Integer)preValue;
                value = v != null && v > 0 ? Boolean.TRUE : Boolean.FALSE;
                return this.setResult(preValue, value);
            }
            if (clz == Long.class) {
                Long v = (Long)preValue;
                value = v != null && v.intValue() > 0 ? Boolean.TRUE : Boolean.FALSE;
                return this.setResult(preValue, value);
            }
            if (clz == Boolean.class) {
                value = (Boolean)preValue;
                return this.setResult(preValue, value);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

