/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import org.eclipse.vjet.dsf.common.converter.ConvertErrorObj;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;

public class ConversionResult<T>
implements IConversionResult<T> {
    private static final long serialVersionUID = 1L;
    private T m_value = null;
    private boolean m_converted = false;
    private Object m_preValue = null;
    private ConvertErrorObj m_error = null;

    @Override
    public T getValue() {
        return this.m_value;
    }

    @Override
    public boolean isConverted() {
        return this.m_converted;
    }

    @Override
    public Object getPreConversionValue() {
        return this.m_preValue;
    }

    public boolean hasError() {
        return this.m_error != null;
    }

    public ConvertErrorObj getError() {
        return this.m_error;
    }

    public void setError(ConvertErrorObj errorObject) {
        this.m_error = errorObject;
    }

    public void clearError() {
        this.m_error = null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("preValue=").append(this.m_preValue);
        buffer.append("; converted=").append(this.m_converted);
        if (this.m_converted) {
            buffer.append("; value=").append(this.m_value);
        } else {
            buffer.append("; errorId=").append(this.m_error);
        }
        return buffer.toString();
    }

    public int hashCode() {
        Boolean converted = this.m_converted ? Boolean.TRUE : Boolean.FALSE;
        return converted.hashCode() + (this.m_preValue == null ? 0 : this.m_preValue.hashCode()) + (this.m_error == null ? 0 : this.m_error.hashCode()) + (this.m_value == null ? 0 : this.m_value.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!ConversionResult.class.isInstance(obj)) {
            return false;
        }
        ConversionResult that = (ConversionResult)obj;
        if (that.m_converted != this.m_converted) {
            return false;
        }
        if (that.m_preValue != null && !that.m_preValue.equals(this.m_preValue) || that.m_preValue == null && that.m_preValue != null) {
            return false;
        }
        if (that.m_error != null && !that.m_error.equals(this.m_error) || that.m_error == null && that.m_error != null) {
            return false;
        }
        return (that.m_value == null || that.m_value.equals(this.m_value)) && (that.m_value != null || that.m_value == null);
    }

    protected void setValue(T value) {
        this.m_value = value;
    }

    protected void setPreConversionValue(Object preValue) {
        this.m_preValue = preValue;
    }

    protected void setConverted(boolean converted) {
        this.m_converted = converted;
    }
}

