/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class IntegerArrayConverter
extends BaseConverter<Integer[]> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String[].class};
        VALID_CONVERSION_TYPES = IntegerArrayConverter.immutableTypeList(types);
    }

    @Override
    public Class<Integer[]> getTargetType() {
        return Integer[].class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Integer[]> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Integer[] values = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String[].class) {
                values = this.getValueAsIntegerArray((String[])preValue);
                return this.setResult(preValue, values);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

