/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;

public class IntegerConverter
extends BaseConverter<Integer> {
    protected static final Integer ONE = new Integer(1);
    protected static final Integer ZERO = new Integer(0);
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String.class, Integer.class, Boolean.class, BaseEnum.class, Enum.class};
        VALID_CONVERSION_TYPES = IntegerConverter.immutableTypeList(types);
    }

    @Override
    public Class<Integer> getTargetType() {
        return Integer.class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Integer> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Integer value = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String.class) {
                if (preValue.toString().length() == 0 && this.isEmptyStringTreatedAsNull()) {
                    return this.setResult(preValue, null);
                }
                value = this.getValueAsInteger((String)preValue);
                return this.setResult(preValue, value);
            }
            if (BaseEnum.class.isAssignableFrom(clz)) {
                value = new Integer(((BaseEnum)preValue).getId());
                return this.setResult(preValue, value);
            }
            if (Enum.class.isAssignableFrom(clz)) {
                value = new Integer(((Enum)preValue).ordinal());
                return this.setResult(preValue, value);
            }
            if (clz == Integer.class) {
                value = (Integer)preValue;
                return this.setResult(preValue, value);
            }
            if (clz == Boolean.class) {
                value = (Boolean)preValue != false ? ONE : ZERO;
                return this.setResult(preValue, value);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

