/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class LongArrayConverter
extends BaseConverter<Long[]> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String[].class};
        VALID_CONVERSION_TYPES = LongArrayConverter.immutableTypeList(types);
    }

    @Override
    public Class<Long[]> getTargetType() {
        return Long[].class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Long[]> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Long[] values = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String[].class) {
                values = this.getValueAsLongArray((String[])preValue);
                return this.setResult(preValue, values);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

