/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class LongConverter
extends BaseConverter<Long> {
    protected static final Long ONE = new Long(1L);
    protected static final Long ZERO = new Long(0L);
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String.class, Integer.class, Long.class, Boolean.class};
        VALID_CONVERSION_TYPES = LongConverter.immutableTypeList(types);
    }

    @Override
    public Class<Long> getTargetType() {
        return Long.class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<Long> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        Long value = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String.class) {
                if (preValue.toString().length() == 0 && this.isEmptyStringTreatedAsNull()) {
                    return this.setResult(preValue, null);
                }
                value = this.getValueAsLong((String)preValue);
                return this.setResult(preValue, value);
            }
            if (clz == Integer.class) {
                value = new Long(((Integer)preValue).longValue());
                return this.setResult(preValue, value);
            }
            if (clz == Long.class) {
                value = (Long)preValue;
                return this.setResult(preValue, value);
            }
            if (clz == Boolean.class) {
                value = (Boolean)preValue != false ? ONE : ZERO;
                return this.setResult(preValue, value);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

