/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.Map;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureXmlSerializer;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.vsf.dervlet.dap.Assertion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AssertionSerializationHelper {
    private static final String CLZNAME_ASSERTION = "Assertion";
    private static final String TAGNAME_ASSERTIOIN = "Assertion";
    private static final String TAGNAME_ACONTENT = "AContent";
    private static final String TAGNAME_APATH = "APath";
    private static final String TAGNAME_ACTIONS = "Actions";
    private static final String ATTRNAME_CMD = "cmd";
    private static final String FLDNAME_CONTENT = "m_content";
    private static final String FLDNAME_PATH = "m_path";
    private static final String FLDNAME_CMD = "m_cmd";
    private static final String FLDNAME_ACTIONS = "m_actions";
    private static final String DOT = ".";

    private AssertionSerializationHelper() {
    }

    public static void enableAssertion() {
        Map serRegistry = DapCtx.ctx().getDapConfig().getDapCaptureDataSerializerRegistry();
        serRegistry.put("Assertion", AssertionSerializer.class);
        serRegistry.put("Assertion.m_path", DapCaptureXmlSerializer.CharactersSerializer.class);
        serRegistry.put("Assertion.m_content", DapCaptureXmlSerializer.CDataSerializer.class);
        serRegistry.put("Assertion.m_actions", DapCaptureXmlSerializer.CollectionSubSerializer.class);
        Map deserRegistry = DapCtx.ctx().getDapConfig().getDapCaptureDataDeserializerRegistry();
        deserRegistry.put("Assertion", AssertionHandler.class);
        deserRegistry.put(TAGNAME_APATH, AssertionPrimitiveHandler.class);
        deserRegistry.put(TAGNAME_ACONTENT, AssertionPrimitiveHandler.class);
    }

    public static void disableAssertion() {
        Map serRegistry = DapCtx.ctx().getDapConfig().getDapCaptureDataSerializerRegistry();
        serRegistry.remove("Assertion");
        serRegistry.remove("Assertion.m_path");
        serRegistry.remove("Assertion.m_content");
        Map deserRegistry = DapCtx.ctx().getDapConfig().getDapCaptureDataDeserializerRegistry();
        deserRegistry.remove("Assertion");
        deserRegistry.remove(TAGNAME_APATH);
        deserRegistry.remove(TAGNAME_ACONTENT);
    }

    public static class AssertionHandler
    extends DapCaptureXmlSerializer.DapCaptureDataSubHandler {
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            Assertion ass = new Assertion();
            ass.setCmd(attributes.getValue(AssertionSerializationHelper.ATTRNAME_CMD));
            String grpName = (String)this.getObjStack().pop();
            ((DapCaptureData)this.getHolder().getValue()).getCurrentViewCapture().addEventCapture(grpName, (DapCaptureData.IEventCapture)ass);
            this.getObjStack().push(grpName);
            this.getObjStack().push(ass);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.getObjStack().pop();
        }
    }

    public static class AssertionPrimitiveHandler
    extends DapCaptureXmlSerializer.PrimitiveHandler {
        protected String getFldName(String tagName) {
            if (AssertionSerializationHelper.TAGNAME_APATH.equals(tagName)) {
                return AssertionSerializationHelper.FLDNAME_PATH;
            }
            if (AssertionSerializationHelper.TAGNAME_ACONTENT.equals(tagName)) {
                return AssertionSerializationHelper.FLDNAME_CONTENT;
            }
            if (AssertionSerializationHelper.TAGNAME_ACTIONS.equals(tagName)) {
                return AssertionSerializationHelper.FLDNAME_ACTIONS;
            }
            return super.getFldName(tagName);
        }
    }

    public static class AssertionSerializer
    extends DapCaptureXmlSerializer.ObjectSubSerializer {
        protected String[] getAttrFields() {
            return new String[]{AssertionSerializationHelper.FLDNAME_CMD};
        }

        protected String[] getNodeFields() {
            return new String[]{AssertionSerializationHelper.FLDNAME_PATH, AssertionSerializationHelper.FLDNAME_CONTENT, AssertionSerializationHelper.FLDNAME_ACTIONS};
        }

        protected String getDisplayName(String fldName, boolean capitalizeFirst) {
            if (AssertionSerializationHelper.FLDNAME_PATH.equals(fldName)) {
                return AssertionSerializationHelper.TAGNAME_APATH;
            }
            if (AssertionSerializationHelper.FLDNAME_CONTENT.equals(fldName)) {
                return AssertionSerializationHelper.TAGNAME_ACONTENT;
            }
            if (AssertionSerializationHelper.FLDNAME_ACTIONS.equals(fldName)) {
                return AssertionSerializationHelper.TAGNAME_ACTIONS;
            }
            return super.getDisplayName(fldName, capitalizeFirst);
        }
    }
}

