/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.vsf.dapunit.DomError;
import org.eclipse.vjet.vsf.dapunit.IDomValidator;

public class SimpleDomValidator
implements IDomValidator {
    private String[] m_regExFilters;

    public SimpleDomValidator() {
    }

    public SimpleDomValidator(String[] regExFilters) {
        this.m_regExFilters = regExFilters;
    }

    @Override
    public DomError validate(DapCaptureData.IDomChange expected, DapCaptureData.IDomChange actual) {
        if (expected == null || expected.toString() == null) {
            return new DomError(DomError.Type.EXPECTED_DOM_CHANGE_NULL, "No more dom change expected");
        }
        if (actual == null || actual.toString() == null) {
            return new DomError(DomError.Type.ACTUAL_DOM_CHANGE_NULL, "Actual dom change is null");
        }
        if (actual.toString().equals(expected.toString())) {
            return null;
        }
        if (this.isEquals(actual.toString(), expected.toString())) {
            return null;
        }
        return new DomError(DomError.Type.ACTUAL_DOM_CHANGE_INVALID, "Actual dom change doesn't match extected dom change");
    }

    public String[] getRegExFilters() {
        return this.m_regExFilters;
    }

    public SimpleDomValidator setRegExFilters(String[] regExFilters) {
        this.m_regExFilters = regExFilters;
        return this;
    }

    private boolean isEquals(String source, String target) {
        boolean equals = source.equalsIgnoreCase(target);
        if (!equals && this.m_regExFilters != null) {
            int i = 0;
            while (i < this.m_regExFilters.length) {
                String targetNew;
                String filter = this.m_regExFilters[i];
                Pattern p = Pattern.compile(filter);
                Matcher sourceMatcher = p.matcher(source);
                Matcher targetMatcher = p.matcher(target);
                String sourceNew = sourceMatcher.replaceAll(filter);
                if (sourceNew.equalsIgnoreCase(targetNew = targetMatcher.replaceAll(filter))) {
                    return true;
                }
                ++i;
            }
        }
        return equals;
    }
}

