/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dapunit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.vsf.dapunit.IMsgValidator;
import org.eclipse.vjet.vsf.dapunit.MsgError;

public class SimpleMsgValidator
implements IMsgValidator {
    private String[] m_regExFilters;

    public SimpleMsgValidator() {
    }

    public SimpleMsgValidator(String[] regExFilters) {
        this.m_regExFilters = regExFilters;
    }

    @Override
    public MsgError validate(String expected, String actual) {
        if (expected == null) {
            return new MsgError("No more msg expected");
        }
        if (actual == null) {
            return new MsgError("Actual msg is null");
        }
        if (actual.equals(expected)) {
            return null;
        }
        if (this.isEquals(actual, expected)) {
            return null;
        }
        return new MsgError("Actual msg doesn't match extected msg");
    }

    public String[] getRegExFilters() {
        return this.m_regExFilters;
    }

    public SimpleMsgValidator setRegExFilters(String[] regExFilters) {
        this.m_regExFilters = regExFilters;
        return this;
    }

    private boolean isEquals(String source, String target) {
        boolean equals = source.equalsIgnoreCase(target);
        if (!equals && this.m_regExFilters != null) {
            int i = 0;
            while (i < this.m_regExFilters.length) {
                String targetNew;
                String filter = this.m_regExFilters[i];
                Pattern p = Pattern.compile(filter);
                Matcher sourceMatcher = p.matcher(source);
                Matcher targetMatcher = p.matcher(target);
                String sourceNew = sourceMatcher.replaceAll(filter);
                if (sourceNew.equalsIgnoreCase(targetNew = targetMatcher.replaceAll(filter))) {
                    return true;
                }
                ++i;
            }
        }
        return equals;
    }
}

