/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.dap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.liveconnect.client.DLCHttpResource;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCResourceProvider;

public class AwuResourceProvider
implements IDLCResourceProvider {
    private static final String BASE = "/awu";
    private Map<String, String> mimeMap = new HashMap<String, String>();

    public AwuResourceProvider() {
        this.mimeMap.put("gif", "image/gif");
        this.mimeMap.put("png", "image/png");
        this.mimeMap.put("jpg", "image/jpeg");
        this.mimeMap.put("css", "text/css");
        this.mimeMap.put("js", "application/javascript");
    }

    public String getBaseUrl() {
        return BASE;
    }

    public DLCHttpResource getResource(String name) {
        if (name.startsWith("AwuResourceProvider")) {
            return null;
        }
        byte[] content = null;
        try {
            InputStream is = ResourceUtil.getResourceAsStream(AwuResourceProvider.class, (String)name);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (is.available() > 0) {
                os.write(is.read());
            }
            content = os.toByteArray();
        }
        catch (IOException e) {
            throw new DsfRuntimeException((Throwable)e);
        }
        DLCHttpResource resource = null;
        if (content != null) {
            resource = new DLCHttpResource();
            resource.setName(name);
            resource.setContent(content);
            String ext = name.substring(name.lastIndexOf(".") + 1, name.length());
            String type = this.mimeMap.get(ext);
            if (type == null) {
                type = "";
            }
            resource.setMimeType(type);
        }
        return resource;
    }
}

