/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.dervlet.defaultdervs;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.view.DefaultViewSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vsf.aggregator.view.DocProcessor;
import org.eclipse.vjet.vsf.dervlet.DsfDervlet;
import org.eclipse.vjet.vsf.dervlet.defaultdervs.ANodeToDocument;
import org.eclipse.vjet.vsf.dervlet.defaultdervs.DervletAdminServlet;
import org.eclipse.vjet.vsf.docprocessing.ProductionCtx;

public class VjDervlet
extends DsfDervlet {
    private static final String PARENT_ELEM_ID = "__dap_target_elem";
    private static final DapCtx.ExeMode DEFAULT_MODE = DapCtx.ExeMode.ACTIVE;
    private static final long serialVersionUID = 1L;
    public static int REMOTE_PORT = 7564;
    private static String JSR_SUFFIX = "Jsr";
    private Class<?> m_jsrClz = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("Class name missing");
        }
        Class<?> clz = VjDervlet.getJsrClass(args[0]);
        if (clz != null) {
            VjDervlet runner = new VjDervlet();
            runner.setJsrClz(clz);
            runner.runAsServer();
        }
    }

    private static Class<?> getJsrClass(String className) {
        if (className == null) {
            throw new NullPointerException("Class name cannot be null");
        }
        String jsrName = String.valueOf(className) + JSR_SUFFIX;
        return VjDervlet.getClz(jsrName);
    }

    private static Class<?> getClz(String jsrName) {
        Class<?> clz = null;
        try {
            clz = Class.forName(jsrName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return clz;
    }

    public VjDervlet() {
        super("vjRunner", "/vjRunner?dapMode=A");
    }

    @Override
    public void init() throws ServletException {
        DapCtx.ExeMode dapMode = DEFAULT_MODE;
        String dapEnv = System.getProperty("dapMode");
        if ("W".equalsIgnoreCase(dapEnv)) {
            dapMode = DapCtx.ExeMode.WEB;
        } else if ("T".equalsIgnoreCase(dapEnv)) {
            dapMode = DapCtx.ExeMode.TRANSLATE;
        }
        this.getDapIntercepter().setDapMode(dapMode);
    }

    @Override
    public DNode createFragment(HttpServletRequest request) {
        String className = request.getParameter("class");
        if (className != null && className.length() > 0) {
            Class<?> jsr = VjDervlet.getJsrClass(className);
            if (jsr == null) {
                throw new RuntimeException("Unable to find class for " + className);
            }
            this.m_jsrClz = jsr;
        }
        if (this.m_jsrClz == null) {
            throw new RuntimeException("Unable to run as Dervlet");
        }
        String triggerMtdName = VjDervlet.getTriggerMethodName(className);
        if (triggerMtdName == null || triggerMtdName.length() == 0) {
            return new DText("Unable to find a suitable trigger method. Expects a method with 'ANode' or 'void' return type and no params.");
        }
        DHtmlDocument dNode = null;
        try {
            DefaultViewSpec spec = new DefaultViewSpec();
            spec.setComponentSpec((IComponentSpec)this.m_jsrClz.getField("SPEC").get(this.m_jsrClz));
            ProductionCtx.ctx().getPlan().setViewSpec((IViewSpec)spec);
            Class<?> clz = VjDervlet.getClz(className);
            if (clz == null) {
                return new DText("Error: Class not found for name " + className);
            }
            Method triggerMtd = clz.getMethod(triggerMtdName, new Class[0]);
            boolean isStatic = Modifier.isStatic(triggerMtd.getModifiers());
            dNode = ANodeToDocument.createHtmlDocumentContaining(triggerMtd.getReturnType(), PARENT_ELEM_ID, this.getCallString(clz, triggerMtdName, PARENT_ELEM_ID, isStatic));
            if (dNode instanceof DHtmlDocument) {
                new DocProcessor(ProductionCtx.ctx().getPlan()).process(dNode);
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            return new DText("Tried: /vjRunner?" + request.getQueryString() + ", got: " + DervletAdminServlet.toMessageString(e1));
        }
        return dNode;
    }

    private String getCallString(Class<?> clz, String mtdName, String elemId, boolean isStatic) {
        StringBuilder sb = new StringBuilder();
        if (isStatic) {
            sb.append(clz.getName()).append('.').append(mtdName).append("()");
        } else {
            sb.append("(function () {var rs=new ").append(clz.getName()).append("();");
            sb.append("return rs.").append(mtdName).append("();})()");
        }
        return sb.toString();
    }

    private static String getTriggerMethodName(String className) {
        Class<?> returnType;
        Method mtd;
        Class<?> clz = VjDervlet.getClz(className);
        Method[] methodArray = clz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            mtd = methodArray[n2];
            if (Modifier.isPublic(mtd.getModifiers()) && (HtmlElement.class.isAssignableFrom(returnType = mtd.getReturnType()) || HtmlDocument.class.isAssignableFrom(returnType)) && mtd.getParameterTypes().length == 0) {
                return mtd.getName();
            }
            ++n2;
        }
        methodArray = clz.getDeclaredMethods();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            mtd = methodArray[n2];
            if (Modifier.isPublic(mtd.getModifiers()) && Void.TYPE.equals(returnType = mtd.getReturnType()) && mtd.getParameterTypes().length == 0) {
                return mtd.getName();
            }
            ++n2;
        }
        return null;
    }

    public Class<?> getJsrClz() {
        return this.m_jsrClz;
    }

    public void setJsrClz(Class<?> clz) {
        this.m_jsrClz = clz;
    }
}

