/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.pattern.js.resolution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.vjet.dsf.resource.permutation.Permutation;
import org.eclipse.vjet.dsf.resource.utils.ResourceHelper;
import org.eclipse.vjet.dsf.util.ClassBasedResourceFinder;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.IJsResourceKey;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.IJsResourceResolver;

public class DefaultJsJavaResourceResolver
implements IJsResourceResolver {
    public static final String FILE_EXTENSION = ".js";
    private static final DefaultJsJavaResourceResolver s_instance = new DefaultJsJavaResourceResolver();
    private static URL s_empty;

    static {
        try {
            s_empty = new URL("http://empty");
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static DefaultJsJavaResourceResolver getInstance() {
        return s_instance;
    }

    private DefaultJsJavaResourceResolver() {
    }

    @Override
    public URL getUrl(IJsResourceKey key) {
        Class<?> anchorClass = key.getAnchorClass();
        for (String permutationStr : key.getPermutation().getExternalsWithResolutionOrder()) {
            String resourceName = DefaultJsJavaResourceResolver.getResourceName(key, permutationStr);
            URL url = UrlCache.getInstance().getUrl(anchorClass, resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static String getResourceName(IJsResourceKey key, String permutationStr) {
        String resourceName = ResourceHelper.getResourceName((String)key.getResourceName(), (Permutation)key.getPermutation(), (String)permutationStr, (String)FILE_EXTENSION);
        return resourceName;
    }

    public static void clearCache() {
        UrlCache.clear();
    }

    private static class ResourceFinder {
        private final ClassBasedResourceFinder m_finder;
        private final String m_baseUri;

        ResourceFinder(Class clz) {
            this.m_finder = ClassBasedResourceFinder.getFinder((Class)clz);
            String name = clz.getName();
            this.m_baseUri = name.substring(0, name.lastIndexOf(".") + 1).replace(".", "/");
        }

        URL getResource(String name) {
            return this.m_finder.findResource(String.valueOf(this.m_baseUri) + name);
        }
    }

    static class UrlCache {
        private static final UrlCache s_instance = new UrlCache();
        private volatile ConcurrentMap<Class<?>, UrlCachePerClass> m_cache = new ConcurrentHashMap(100);

        UrlCache() {
        }

        private static UrlCache getInstance() {
            return s_instance;
        }

        private URL getUrl(Class<?> c, String name) {
            UrlCachePerClass old;
            UrlCachePerClass urlCachePerClz = (UrlCachePerClass)this.m_cache.get(c);
            if (urlCachePerClz == null && (old = this.m_cache.putIfAbsent(c, urlCachePerClz = new UrlCachePerClass(c))) != null) {
                urlCachePerClz = old;
            }
            return urlCachePerClz.getResource(name);
        }

        static void clear() {
            UrlCache.getInstance().m_cache = new ConcurrentHashMap(100);
        }

        private static class ClearCacheListener
        implements PropertyChangeListener {
            private ClearCacheListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UrlCache.clear();
            }
        }
    }

    private static class UrlCachePerClass {
        private final ConcurrentMap<String, URL> m_cache = new ConcurrentHashMap<String, URL>(30);
        private final ResourceFinder m_finder;

        UrlCachePerClass(Class clz) {
            this.m_finder = new ResourceFinder(clz);
        }

        URL getResource(String name) {
            URL url = (URL)this.m_cache.get(name);
            if (url == null) {
                URL old;
                url = this.m_finder.getResource(name);
                if (url == null) {
                    url = s_empty;
                }
                if ((old = this.m_cache.putIfAbsent(name, url)) != null) {
                    url = old;
                }
            }
            if (url == s_empty) {
                return null;
            }
            return url;
        }
    }
}

