/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoPrimitiveSerializer;

public class VjoEnumSerializer
extends VjoPrimitiveSerializer {
    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return type.isEnum();
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getClass().getName().replace('$', '.'));
        sb.append(".");
        sb.append(((Enum)obj).name());
        return sb.toString();
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return false;
    }
}

