/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.view;

import java.util.Set;
import org.eclipse.vjet.dsf.common.CallerIntrospector;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.resource.slot.ExternalizedSlotGrouping;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.slot.plan.ResourceProcessCtx;
import org.eclipse.vjet.dsf.spec.collector.ResourceSpecCollector;
import org.eclipse.vjet.dsf.spec.component.BaseJsComponentSpec;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.resource.IResourceSpec;
import org.eclipse.vjet.dsf.spec.view.ISharedViewSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsRefCollection;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRefMgr;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;

public abstract class BaseViewSpec
implements IViewSpec,
IJsResourceDispenser {
    private final String m_name;
    private IComponentSpec m_componentSpec;
    private JsResourceSlotAssignment m_jsSlotAssignment;
    private ExternalizedSlotGrouping m_slotGroupping = new ExternalizedSlotGrouping();
    private ISharedViewSpec m_sharedViewSpec;
    private boolean m_isSecureRequestSupported = false;
    private ResourceProcessCtx m_resourceProcessCtx = new ResourceProcessCtx();
    private boolean m_isJsSystemLibCache;
    private Set<String> m_jsExclusionResourceUrns;
    private boolean m_isForceJsExclusionCheck = false;
    private Set<String> m_cssExclusionResourceUrns;
    private boolean m_isJsSystemLibVariation = false;
    private boolean m_hasL10nResources;

    public BaseViewSpec(String name) {
        if (name == null) {
            DsfExceptionHelper.chuck((String)"name is null");
        }
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IComponentSpec getComponentSpec() {
        if (this.m_componentSpec == null) {
            this.m_componentSpec = new BaseJsComponentSpec(){};
        }
        return this.m_componentSpec;
    }

    public BaseViewSpec setComponentSpec(IComponentSpec componentSpec) {
        if (componentSpec == null) {
            DsfExceptionHelper.chuck((String)"componentSpec is null");
        }
        this.m_componentSpec = componentSpec;
        return this;
    }

    public BaseViewSpec assignJsSlot(IJsResourceRef resource, String baseSlotName) {
        if (this.m_jsSlotAssignment == null) {
            this.m_jsSlotAssignment = new JsResourceSlotAssignment();
        }
        this.m_jsSlotAssignment.put(resource, baseSlotName);
        return this;
    }

    public BaseViewSpec assignJsSlot(JsResource resource, String baseSlotName) {
        if (this.m_jsSlotAssignment == null) {
            this.m_jsSlotAssignment = new JsResourceSlotAssignment();
        }
        this.m_jsSlotAssignment.put(resource, baseSlotName);
        return this;
    }

    public BaseViewSpec assignJsSlot(String urnPrefix, String baseSlotName) {
        if (this.m_jsSlotAssignment == null) {
            this.m_jsSlotAssignment = new JsResourceSlotAssignment();
        }
        this.m_jsSlotAssignment.put(urnPrefix, baseSlotName);
        return this;
    }

    public BaseViewSpec assignJsSlot(IComponentSpec rootSpec, String baseSlotName) {
        if (this.m_jsSlotAssignment == null) {
            this.m_jsSlotAssignment = new JsResourceSlotAssignment();
        }
        ResourceSpecCollector specCollector = new ResourceSpecCollector();
        specCollector.aggregate(rootSpec);
        for (IResourceSpec spec : specCollector) {
            for (IJsResourceRef resource : spec.getClassDefinitions()) {
                if (this.m_jsSlotAssignment.hasAssignment(resource)) continue;
                this.assignJsSlot(resource, baseSlotName);
            }
            for (IJsResourceRef resource : spec.getExecutingScript()) {
                if (this.m_jsSlotAssignment.hasAssignment(resource)) continue;
                this.assignJsSlot(resource, baseSlotName);
            }
        }
        return this;
    }

    public boolean isJsSystemLibCache() {
        return this.m_isJsSystemLibCache;
    }

    public void setIsJsSystemLibCache(boolean isJsSystemLibCache) {
        this.m_isJsSystemLibCache = isJsSystemLibCache;
    }

    public BaseViewSpec supportSecureRequest() {
        this.m_isSecureRequestSupported = true;
        return this;
    }

    public boolean isSecureRequestSupported() {
        return this.m_isSecureRequestSupported;
    }

    public BaseViewSpec enableDataUri() {
        this.m_resourceProcessCtx.setDataUriEnabled(true);
        return this;
    }

    public boolean isDataUriEnabled() {
        return this.m_resourceProcessCtx.isDataUriEnabled();
    }

    public BaseViewSpec setDataUriMaxRepeatCount(int maxRpt) {
        this.m_resourceProcessCtx.setDataUriMaxRepeatCount(maxRpt);
        return this;
    }

    public int getDataUriMaxRepeatCount() {
        return this.m_resourceProcessCtx.getDataUriMaxRepeatCount();
    }

    public ResourceProcessCtx getResourceProcessCtx() {
        return this.m_resourceProcessCtx;
    }

    public JsResourceSlotAssignment getJsSlotAssignment() {
        return this.m_jsSlotAssignment;
    }

    public void setJsSlotAssignment(JsResourceSlotAssignment assignment) {
        this.m_jsSlotAssignment = assignment;
    }

    public ExternalizedSlotGrouping getExternalizedJsSlotGrouping() {
        return this.m_slotGroupping;
    }

    protected void setExternalizedJsSlotGrouping(ExternalizedSlotGrouping slotGroupping) {
        this.m_slotGroupping = slotGroupping;
    }

    public JsRefCollection getJsRefs() {
        return JsRefMgrAdapter.getRefs(this.getClass());
    }

    protected static IJsResourceRef jsRef(JsResource resource, JsType type) {
        Class ownerClz = CallerIntrospector.getCallingClass();
        IJsResourceRef ref = JsRefMgrAdapter.createJsRef(resource, ownerClz, type);
        JsRefMgrAdapter.addRef(ownerClz, ref);
        return ref;
    }

    protected static IJsResourceRef onFlyJsRef(JsResource resource, JsType type) {
        Class ownerClz = CallerIntrospector.getCallingClass();
        IJsResourceRef ref = JsRefMgrAdapter.createJsRef(resource, ownerClz, type);
        return ref;
    }

    public BaseViewSpec setSharedViewSpec(ISharedViewSpec spec) {
        if (this instanceof ISharedViewSpec) {
            throw new DsfRuntimeException("An ISharedViewSpec cannot set a shared spec. We only support one level of spec sharing.");
        }
        this.m_sharedViewSpec = spec;
        return this;
    }

    @Override
    public ISharedViewSpec getSharedViewSpec() {
        return this.m_sharedViewSpec;
    }

    public Set<String> getJsExclusionResourceUrns() {
        return this.m_jsExclusionResourceUrns;
    }

    public BaseViewSpec setJsExclusionResourceUrns(Set<String> exclusionResourceUrns) {
        this.m_jsExclusionResourceUrns = exclusionResourceUrns;
        return this;
    }

    public Set<String> getCssExclusionResourceUrns() {
        return this.m_cssExclusionResourceUrns;
    }

    public BaseViewSpec setCssExclusionResourceUrns(Set<String> exclusionResourceUrns) {
        this.m_cssExclusionResourceUrns = exclusionResourceUrns;
        return this;
    }

    public boolean isForceJsExclusionCheck() {
        return this.m_isForceJsExclusionCheck;
    }

    public BaseViewSpec setForceJsExclusionCheck(boolean forceJsExclusionCheck) {
        this.m_isForceJsExclusionCheck = forceJsExclusionCheck;
        return this;
    }

    public boolean isJsSystemLibVariation() {
        return this.m_isJsSystemLibVariation;
    }

    public void setJsSystemLibVariation(boolean jsSystemLibVariation) {
        this.m_isJsSystemLibVariation = jsSystemLibVariation;
    }

    @Override
    public boolean hasL10nResources() {
        return this.m_hasL10nResources;
    }

    public void enableL10nResources() {
        this.m_hasL10nResources = true;
    }

    private static class JsRefMgrAdapter
    extends JsResourceRefMgr {
        private JsRefMgrAdapter() {
        }

        protected static synchronized void addRef(Class<? extends IJsResourceDispenser> dispenser, IJsResourceRef ref) {
            JsResourceRefMgr.addRef(dispenser, (IJsResourceRef)ref);
        }

        protected static JsRefCollection getRefs(Class<? extends IJsResourceDispenser> dispenser) {
            return JsResourceRefMgr.getRefs(dispenser);
        }

        protected static IJsResourceRef createJsRef(JsResource resource, Class<? extends IJsResourceDispenser> dispenser, JsType type) {
            return JsResourceRefMgr.createJsRef((JsResource)resource, dispenser, (JsType)type);
        }
    }
}

