/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.window.utils;

public class JsWindowFeatures {
    private static final String RESIZABLE = "resizable";
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String LOCATION = "location";
    private static final String MENUBAR = "menubar";
    private static final String SCROLLBARS = "scrollbars";
    private static final String STATUS = "status";
    private static final String EQUALYES = "=yes";
    private static final String EQUALNO = "=no";
    private boolean m_resizable = false;
    private boolean m_status = false;
    private boolean m_scrollbars = false;
    private boolean m_menubar = false;
    private boolean m_location = false;
    private boolean m_center = false;
    private int m_height = 0;
    private int m_width = 0;

    public JsWindowFeatures(int width, int height) {
        this.setHeight(height);
        this.setWidth(width);
        this.setLocation(true);
        this.setStatus(true);
        this.setMenubar(true);
        this.setScrollbars(true);
    }

    public String createJsWindowFeatures() {
        StringBuilder jsContent = new StringBuilder();
        if (this.getWidth() != 0) {
            jsContent.append("width=" + this.getWidth());
            JsWindowFeatures.addComma(jsContent);
        }
        if (this.getHeight() != 0) {
            jsContent.append("height=" + this.getHeight());
            JsWindowFeatures.addComma(jsContent);
        }
        if (this.isLocation()) {
            jsContent.append("location=yes");
            JsWindowFeatures.addComma(jsContent);
        } else {
            jsContent.append("location=no");
            JsWindowFeatures.addComma(jsContent);
        }
        if (this.isMenubar()) {
            jsContent.append("menubar=yes");
            JsWindowFeatures.addComma(jsContent);
        } else {
            jsContent.append("menubar=no");
            JsWindowFeatures.addComma(jsContent);
        }
        if (this.isScrollbars()) {
            jsContent.append("scrollbars=yes");
            JsWindowFeatures.addComma(jsContent);
        } else {
            jsContent.append("scrollbars=no");
            JsWindowFeatures.addComma(jsContent);
        }
        if (this.isResizable()) {
            jsContent.append("resizable=yes");
            JsWindowFeatures.addComma(jsContent);
        } else {
            jsContent.append("resizable=no");
            JsWindowFeatures.addComma(jsContent);
        }
        if (!this.isStatus()) {
            jsContent.append("status=yes");
        } else {
            jsContent.append("status=no");
        }
        return jsContent.toString();
    }

    private static void addComma(StringBuilder w) {
        w.append(",");
    }

    public final int getHeight() {
        return this.m_height;
    }

    public final void setHeight(int height) {
        this.m_height = height;
    }

    public final boolean isLocation() {
        return this.m_location;
    }

    public final void setLocation(boolean location) {
        this.m_location = location;
    }

    public final boolean isMenubar() {
        return this.m_menubar;
    }

    public final void setMenubar(boolean menubar) {
        this.m_menubar = menubar;
    }

    public final boolean isResizable() {
        return this.m_resizable;
    }

    public final void setResizable(boolean resizable) {
        this.m_resizable = resizable;
    }

    public final boolean isScrollbars() {
        return this.m_scrollbars;
    }

    public final void setScrollbars(boolean scrollbars) {
        this.m_scrollbars = scrollbars;
    }

    public final boolean isStatus() {
        return this.m_status;
    }

    public final void setStatus(boolean status) {
        this.m_status = status;
    }

    public final int getWidth() {
        return this.m_width;
    }

    public final void setWidth(int width) {
        this.m_width = width;
    }

    public final boolean getCenter() {
        return this.m_center;
    }

    public final void setCenter(boolean center) {
        this.m_center = center;
    }
}

