/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DsfDomNotSupportedRuntimeException;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DNamedNodeMap
extends LinkedHashMap<String, DNode>
implements NamedNodeMap {
    private static final long serialVersionUID = -5444798233592030622L;
    private final short m_allowedNodeType;

    DNamedNodeMap(int initialSize, short allowedNodeType) {
        super(initialSize);
        this.m_allowedNodeType = allowedNodeType;
    }

    @Override
    public Node getNamedItem(String name) {
        return (Node)this.get(name);
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        if (node == null) {
            throw new DOMException(3, "null node not allowed");
        }
        if (node.getNodeType() != this.m_allowedNodeType) {
            throw new DOMException(3, "node of type " + node.getNodeType() + " not allowed.  Did not expect a " + node.getClass().getName() + " node");
        }
        DNode dnode = (DNode)node;
        DNode previousNodeIfAny = this.put(node.getNodeName(), dnode);
        return previousNodeIfAny;
    }

    public DNamedNodeMap add(Node node) {
        this.setNamedItem(node);
        return this;
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        DNode removedAttr = (DNode)super.remove(name);
        if (removedAttr == null) {
            throw new DOMException(8, "unable to find node with name " + name);
        }
        removedAttr.deparent();
        return removedAttr;
    }

    @Override
    public Node item(int index) {
        if (index < 0 || index > this.getLength() - 1) {
            return null;
        }
        Iterator entrySet = this.entrySet().iterator();
        int count = 0;
        while (entrySet.hasNext()) {
            Map.Entry mapEntry = entrySet.next();
            if (count == index) {
                return (Node)mapEntry.getValue();
            }
            ++count;
        }
        throw new DsfRuntimeException("Should have found entry at index: " + index);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("getNamedItemNS(...)");
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("getNamedItemNS(...)");
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DsfDomNotSupportedRuntimeException("removeNamedItemNS(...)");
    }
}

