/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.common.node.visitor.AbortDNodeTraversalException;
import org.eclipse.vjet.dsf.common.node.visitor.DNodeVisitStatus;
import org.eclipse.vjet.dsf.common.node.visitor.DefaultDNodeVisitor;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNodeList;

public class GetElementByNSQuery
extends DefaultDNodeVisitor {
    private DNodeList m_answer = null;
    private String m_uri = null;
    private String m_localName = null;
    private boolean m_enableNS = false;

    public GetElementByNSQuery(DNodeList nodeList, String uri, String localName) {
        this.m_answer = nodeList;
        this.m_uri = uri;
        this.m_localName = localName;
        this.m_enableNS = uri != null;
    }

    @Override
    public DNodeVisitStatus visit(DNode node) throws AbortDNodeTraversalException {
        if (node.getNodeType() != 1) {
            return DNodeVisitStatus.CONTINUE;
        }
        if (!this.m_enableNS) {
            if (this.m_localName.equals("*") || node.getNodeName() != null && node.getNodeName().equals(this.m_localName)) {
                this.m_answer.privateAdd(node);
            }
        } else if (this.m_localName.equals("*")) {
            if (this.m_uri != null && this.m_uri.equals("*")) {
                this.m_answer.privateAdd(node);
            } else if (this.m_uri == null && node.getNamespaceURI() == null || this.m_uri != null && this.m_uri.equals(node.getNamespaceURI())) {
                this.m_answer.privateAdd(node);
            }
        } else if (node.getLocalName() != null && node.getLocalName().equals(this.m_localName)) {
            if (this.m_uri != null && this.m_uri.equals("*")) {
                this.m_answer.privateAdd(node);
            } else if (this.m_uri == null && node.getNamespaceURI() == null || this.m_uri != null && this.m_uri.equals(node.getNamespaceURI())) {
                this.m_answer.privateAdd(node);
            }
        }
        return DNodeVisitStatus.CONTINUE;
    }
}

