/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class NodeToDDocument {
    public static DDocument createDocumentContaining(Node node) {
        if (node instanceof DDocument) {
            return (DDocument)node;
        }
        if (node instanceof CDATASection || node instanceof Text || node instanceof EntityReference || node instanceof Comment || node instanceof ProcessingInstruction || node instanceof DocumentFragment) {
            return NodeToDDocument.newElemAndAppend(node);
        }
        DDocument doc = new DDocument();
        if (node instanceof DocumentType) {
            doc.appendChild(node);
            return doc;
        }
        if (node instanceof Entity) {
            DocumentType doctype = doc.createDocumentType("qname", "pubId", "sysId");
            doctype.getEntities().setNamedItem(node);
            doc.appendChild(doctype);
            return doc;
        }
        if (node instanceof Notation) {
            DocumentType doctype = doc.createDocumentType("qname", "pubId", "sysId");
            doctype.getNotations().setNamedItem(node);
            doc.appendChild(doctype);
            return doc;
        }
        if (node instanceof Attr) {
            DElement elem = new DElement("v4");
            elem.getAttributes().setNamedItem(node);
            doc.appendChild(elem);
            return doc;
        }
        doc.appendChild(node);
        return doc;
    }

    private static DDocument newElemAndAppend(Node child) {
        DDocument doc = new DDocument();
        DElement root = new DElement("v4");
        root.appendChild(child);
        doc.appendChild(root);
        return doc;
    }
}

