/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.Basic;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.FetchType;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.edit.BasicItemProvider;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BasicMappingComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private Basic basic;
    private EditingDomain editingDomain;
    private DaliItemProviderAdapterFactory adapterFactory;
    private BasicItemProvider mappingItemProvider;
    private ColumnComposite columnComposite;
    private ComboViewer fetchTypeComboViewer;
    private INotifyChangedListener mappingListener;
    static /* synthetic */ Class class$0;

    protected BasicMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.mappingItemProvider = (BasicItemProvider)this.adapterFactory.createBasicAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        Label fetchTypeLabel = new Label((Composite)this, 16384);
        fetchTypeLabel.setText("Fetch Type:");
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
    }

    private ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BasicMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchType fetchType = (FetchType)selection.getFirstElement();
                    if (!BasicMappingComposite.this.basic.getFetchType().equals(fetchType)) {
                        BasicMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)BasicMappingComposite.this.editingDomain, (Object)BasicMappingComposite.this.basic, (Object)DaliPackage.eINSTANCE.getBasic_FetchType(), (Object)fetchType));
                    }
                }
            }
        });
        return viewer;
    }

    public void populate(EObject model) {
        if (this.basic != null) {
            this.mappingItemProvider.removeListener(this.getMappingListener());
            this.basic.eAdapters().remove((Object)this.mappingItemProvider);
        }
        if (model == null) {
            this.basic = null;
            this.columnComposite.populate(null);
            this.populating = false;
            return;
        }
        this.basic = (Basic)((PersistentAttribute)model).getFlavor();
        this.mappingItemProvider.addListener(this.getMappingListener());
        this.basic.eAdapters().add((Object)this.mappingItemProvider);
        if (this.basic.getFetchType() == FetchType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.DEFAULT_LITERAL));
            }
        } else if (this.basic.getFetchType() == FetchType.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.LAZY_LITERAL));
        }
        this.columnComposite.populate((EObject)this.basic.getColumn());
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (((ViewerNotification)notification).getElement() instanceof Basic && notification.getFeatureID(Basic.class) == 2) {
                        FetchType fetchType = (FetchType)notification.getNewValue();
                        Display.getDefault().syncExec(new Runnable(this, fetchType){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ FetchType val$fetchType;
                            {
                                this.this$1 = var1_1;
                                this.val$fetchType = fetchType;
                            }

                            public void run() {
                                if (((StructuredSelection)BasicMappingComposite.access$3(2.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$fetchType) {
                                    BasicMappingComposite.access$3(2.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$fetchType));
                                }
                            }
                        });
                    }
                }

                static /* synthetic */ BasicMappingComposite access$0(2 var0) {
                    return var0.BasicMappingComposite.this;
                }
            };
        }
        return this.mappingListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.fetchTypeComboViewer.getCombo().setFocus();
    }

    public void dispose() {
        this.mappingItemProvider.removeListener(this.mappingListener);
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$3(BasicMappingComposite basicMappingComposite) {
        return basicMappingComposite.fetchTypeComboViewer;
    }

    public static class BasicMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new BasicMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

