/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.ManyToMany;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.ReferencePersistentAttributeFlavorItemProvider;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinTableComposite;
import org.eclipse.dali.ui.views.ReferenceMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ManyToManyMappingComposite
extends ReferenceMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    protected JoinTableComposite joinTableComposite;
    static /* synthetic */ Class class$0;

    protected ManyToManyMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected ReferencePersistentAttributeFlavorItemProvider createReferenceMappingTypeItemProvider(DaliItemProviderAdapterFactory adapterFactory) {
        return (ReferencePersistentAttributeFlavorItemProvider)adapterFactory.createOneToManyAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Label targetEntityLabel = new Label((Composite)this, 16384);
        targetEntityLabel.setText("Target Entity:");
        this.targetEntityCombo = this.buildTargetEntityCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(this);
        Label cascadeTypeLabel = new Label((Composite)this, 16384);
        cascadeTypeLabel.setText("Cascade Type:");
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label((Composite)this, 16384);
        fetchTypeLabel.setText("Fetch Type:");
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label((Composite)this, 16384);
        mappedByLabel.setText("Mapped By:");
        this.mappedByCombo = this.buildMappedByCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        this.joinTableComposite = new JoinTableComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.joinTableComposite.setLayoutData(gridData);
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ManyToManyMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (ManyToManyMappingComposite.this.getManyToManyMapping().getMappedBy() == null || ManyToManyMappingComposite.this.getManyToManyMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (ManyToManyMappingComposite.this.getManyToManyMapping().getMappedBy() == null || !ManyToManyMappingComposite.this.getManyToManyMapping().getMappedBy().equals(mappedBy)) {
                    ManyToManyMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ManyToManyMappingComposite.this.editingDomain, (Object)ManyToManyMappingComposite.this.getManyToManyMapping(), (Object)DaliPackage.eINSTANCE.getMultiReferenceMapping_MappedBy(), (Object)mappedBy));
                }
            }
        });
        return combo;
    }

    private ManyToMany getManyToManyMapping() {
        return (ManyToMany)this.mappingType;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        if (model != null) {
            this.populateMappedByCombo();
            this.populateJoinTablePanel();
        } else {
            this.unpopulateJoinTablePanel();
        }
        this.populating = false;
    }

    private void populateMappedByCombo() {
        String mappedBy = this.getManyToManyMapping().getMappedBy();
        Iterator i = this.getManyToManyMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    private void unpopulateJoinTablePanel() {
        this.joinTableComposite.populate(null);
    }

    private void populateJoinTablePanel() {
        this.joinTableComposite.populate((EObject)((ManyToMany)this.mappingType).getJoinTable());
    }

    protected void mappingTypeChanged(Notification notification) {
        super.mappingTypeChanged(notification);
        if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 6) {
            final String mappedBy = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (ManyToManyMappingComposite.this.mappedByCombo.getText() == null || !ManyToManyMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                        if (mappedBy == null) {
                            ManyToManyMappingComposite.this.mappedByCombo.setText("");
                        } else {
                            ManyToManyMappingComposite.this.mappedByCombo.setText(mappedBy);
                        }
                    }
                }
            });
        }
    }

    public static class ManyToManyMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new ManyToManyMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

