/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.wrappers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.ConnectionRepository;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.wrappers.DatabaseWrapper;
import org.eclipse.dali.db.wrappers.RdbWrapper;
import org.eclipse.dali.db.wrappers.SchemaWrapper;
import org.eclipse.dali.db.wrappers.SequenceWrapper;
import org.eclipse.dali.db.wrappers.TableWrapper;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class ConnectionInfoWrapper
extends RdbWrapper {
    private DatabaseWrapper sharedDatabase;
    private static final String USER_NAME = "user";
    private static final String PASSWORD = "password";
    private static final String PROTOCOL = "protocol";
    static /* synthetic */ Class class$0;

    public static Collection wrapAll(Iterator modelIterator) {
        return ConnectionInfoWrapper.wrapAll(modelIterator, ConnectionInfoWrapper.class);
    }

    protected ConnectionInfoWrapper() {
    }

    public ConnectionInfoWrapper(Object modelObject) {
        super(modelObject);
    }

    private ConnectionInfo model() {
        return (ConnectionInfo)this.getModel();
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.addListenerToConnectionRepository(listener);
        this.addConnectionSharingListener(this.buildConnectionSharingListener(listener));
    }

    private ConnectionSharingListener buildConnectionSharingListener(final ConnectionListener listener) {
        return new ConnectionSharingListener(){

            public void sharedConnectionAdded(ConnectionInfo info, Connection connection) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.sharedConnectionAdded(new ConnectionInfoWrapper(info), connection);
                }
            }

            public void sharedConnectionRemove(ConnectionInfo info, Connection connection) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.sharedConnectionRemove(new ConnectionInfoWrapper(info), connection);
                }
            }

            public void sharedDatabaseAdded(ConnectionInfo info, Database database) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.sharedDatabaseAdded(new ConnectionInfoWrapper(info), new DatabaseWrapper(database));
                }
            }

            public void sharedDatabaseRemove(ConnectionInfo info, Database database) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.sharedDatabaseRemove(new ConnectionInfoWrapper(info), new DatabaseWrapper(database));
                }
            }

            public void onSQLException(ConnectionInfo info, Connection connection, SQLException exception) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.onSQLException(new ConnectionInfoWrapper(info), connection, exception);
                }
            }
        };
    }

    private void addListenerToConnectionRepository(ConnectionListener listener) {
        ConnectionRepository connectionRepository = PersistenceDbPlugin.getDefault().getConnectionRepository();
        connectionRepository.addListener(this.buildConnectionManagerListener(listener));
    }

    private ConnectionManagerListener buildConnectionManagerListener(final ConnectionListener listener) {
        return new ConnectionManagerListener(){

            public void connectionInfoCreated(ConnectionInfo info) {
            }

            public void connectionInfoRemoved(String name) {
            }

            public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.connectionInfoRenamed(previousName, new ConnectionInfoWrapper(info));
                }
            }

            public void connected(ConnectionInfo info, Connection connection) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.connected(new ConnectionInfoWrapper(info), connection);
                }
            }

            public void disconnected(ConnectionInfo info, Connection connection) {
                if (ConnectionInfoWrapper.this.model() == info) {
                    listener.disconnected(new ConnectionInfoWrapper(info), connection);
                }
            }
        };
    }

    private void addConnectionSharingListener(ConnectionSharingListener listener) {
        this.model().addConnectionSharingListener(listener);
    }

    private void removeConnectionSharingListener(ConnectionSharingListener listener) {
        this.model().removeConnectionSharingListener(listener);
    }

    protected void initializeFromModel(Object modelObject) {
        super.initializeFromModel(modelObject);
        Database database = this.model().getSharedDatabase();
        if (database != null) {
            this.sharedDatabase = new DatabaseWrapper(database);
        }
        this.addConnectionSharingListener(this.buildSharedDatabaseListener());
    }

    private ConnectionSharingListener buildSharedDatabaseListener() {
        return new ConnectionSharingListener(){

            public void sharedConnectionAdded(ConnectionInfo info, Connection connection) {
            }

            public void sharedConnectionRemove(ConnectionInfo info, Connection connection) {
            }

            public void sharedDatabaseAdded(ConnectionInfo info, Database database) {
                ConnectionInfoWrapper.this.log("[ConnectionInfoWrapper] DatabaseAdded");
                if (info == ConnectionInfoWrapper.this.model()) {
                    ConnectionInfoWrapper.this.sharedDatabase = new DatabaseWrapper(database);
                }
            }

            public void sharedDatabaseRemove(ConnectionInfo info, Database database) {
                ConnectionInfoWrapper.this.log("[ConnectionInfoWrapper] DatabaseRemoved");
                if (database == ConnectionInfoWrapper.this.sharedDatabase.getModel()) {
                    ConnectionInfoWrapper.this.sharedDatabase = null;
                }
            }

            public void onSQLException(ConnectionInfo info, Connection connection, SQLException exception) {
            }
        };
    }

    public boolean isConnected() {
        return this.model().getSharedDatabase() != null;
    }

    public void connect(String userName, String password) throws Exception {
        Connection userConnection = null;
        this.setUserName(userName);
        this.setPassword(password);
        try {
            userConnection = this.model().connect();
        }
        catch (Exception e) {
            this.log("[ConnectionInfoWrapper] Error: Connect failed: " + e.toString() + " - " + e.getMessage());
            throw e;
        }
        if (userConnection == null) {
            throw new RuntimeException("User: " + userName + " Not Logged");
        }
        this.setSharedConnection(userConnection);
        new DatabaseProviderHelper().setDatabase(userConnection, this.model(), this.getDatabaseName());
        this.saveConnectionInfo();
    }

    public void disconnect() {
        try {
            Connection connection = this.getSharedConnection();
            if (this.isConnected()) {
                this.removeSharedDatabase();
            }
            if (connection != null) {
                this.removeSharedConnection();
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Cannot disconnect: " + this.getName());
        }
    }

    public SchemaWrapper getDefaultSchema() {
        if (this.getSharedDatabase() == null) {
            return null;
        }
        return this.getSharedDatabase().getSchemaNamed(this.getUserName());
    }

    public SchemaWrapper getSchemaNamed(String schemaName) {
        if (this.getSharedDatabase() == null) {
            return null;
        }
        return this.getSharedDatabase().getSchemaNamed(schemaName);
    }

    public Iterator schemaNames() {
        if (!this.isConnected()) {
            return NullIterator.instance();
        }
        TransformationIterator iterator = new TransformationIterator(this.sharedDatabase.schemas()){

            protected Object transform(Object next) {
                return ((SchemaWrapper)next).getName();
            }
        };
        return iterator;
    }

    public Collection getUserTables(String schemaName) {
        SchemaWrapper schema = this.getSchemaNamed(schemaName);
        return schema != null ? schema.getTables() : new ArrayList();
    }

    public Iterator userTables(String schemaName) {
        Collection tables = this.getUserTables(schemaName);
        return tables != null ? tables.iterator() : NullIterator.instance();
    }

    public Iterator userTableNames(String schemaName) {
        TransformationIterator iterator = new TransformationIterator(this.userTables(schemaName)){

            protected Object transform(Object next) {
                return ((TableWrapper)next).getName();
            }
        };
        return iterator;
    }

    public Collection getUserTableNames(String schemaName) {
        return CollectionTools.collection((Iterator)this.userTableNames(schemaName));
    }

    public Collection getUserSequences(String schemaName) {
        SchemaWrapper schema = this.getSchemaNamed(schemaName);
        return schema != null ? schema.getSequences() : new ArrayList();
    }

    public Iterator userSequences(String schemaName) {
        Collection sequences = this.getUserSequences(schemaName);
        return sequences != null ? sequences.iterator() : NullIterator.instance();
    }

    public Iterator userSequenceNames(String schemaName) {
        TransformationIterator iterator = new TransformationIterator(this.userSequences(schemaName)){

            protected Object transform(Object next) {
                return ((SequenceWrapper)next).getName();
            }
        };
        return iterator;
    }

    public String getName() {
        return this.model().getName();
    }

    public String getUserName() {
        return this.model().getUserName();
    }

    public void setUserName(String userName) {
        this.getProperties().setProperty(USER_NAME, userName);
    }

    public String getPassword() {
        return this.model().getPassword();
    }

    public void setPassword(String password) {
        this.getProperties().setProperty(PASSWORD, password);
    }

    public String getConnectionProtocol() {
        return this.getProperties().getProperty(PROTOCOL);
    }

    public void setConnectionProtocol(String connectionProtocol) {
        this.getProperties().setProperty(PROTOCOL, connectionProtocol);
    }

    public String getDatabaseProductVersion() {
        return this.model().getDatabaseProductVersion();
    }

    public void saveConnectionInfo() throws FileNotFoundException, IOException {
        this.model().saveConnectionInfo();
    }

    private Connection getSharedConnection() {
        return this.model().getSharedConnection();
    }

    private void setSharedConnection(Connection connection) {
        this.model().setSharedConnection(connection);
    }

    private void removeSharedConnection() {
        this.model().removeSharedConnection();
    }

    private Properties getProperties() {
        return this.model().getProperties();
    }

    public String getDatabaseName() {
        return this.model().getDatabaseName();
    }

    public void setDatabaseName(String databaseName) {
        this.model().setDatabaseName(databaseName);
    }

    public DatabaseWrapper getSharedDatabase() {
        return this.sharedDatabase;
    }

    private void removeSharedDatabase() {
        this.model().removeSharedDatabase();
    }

    public String getURL() {
        return this.model().getURL();
    }

    public void setURL(String url) {
        this.model().setURL(url);
    }

    public String getDriverClassName() {
        return this.model().getDriverClassName();
    }

    public void setDriverClassName(String driverClassName) {
        this.model().setDriverClassName(driverClassName);
    }

    public String getLoadingPath() {
        return this.model().getLoadingPath();
    }

    public void setLoadingPath(String loadingPath) {
        this.model().setLoadingPath(loadingPath);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }
}

