/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.adapters.java.Member;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;

public abstract class AbstractAnnotationElementAdapter {
    private AnnotationElementInfo info;

    public AbstractAnnotationElementAdapter(AnnotationElementInfo info) {
        this.info = info;
    }

    protected AnnotationElementInfo getInfo() {
        return this.info;
    }

    public boolean updatePersElement(CompilationUnit astRoot) {
        String javaValue = this.javaValue(astRoot);
        String persValue = this.info.persValue();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.info.setPersValue(javaValue);
            return true;
        }
        return false;
    }

    public boolean updateJavaElement() {
        CompilationUnit astRoot = this.info.member().createASTRoot();
        String javaValue = this.javaValue(astRoot);
        String persValue = this.info.persValue();
        if (persValue == null && javaValue == null) {
            return false;
        }
        if (persValue == null || !persValue.equals(javaValue)) {
            if (persValue == null || persValue.equals(this.info.defaultValue())) {
                this.info.member().removeAnnotationElement(this.info.annotationName(), this.info.annotationElementName());
            } else {
                this.setJavaValue(persValue);
            }
            return true;
        }
        return false;
    }

    protected void setJavaValue(final String javaValue) {
        JDTTools.addImport(this.info.member().getJDTMember().getCompilationUnit(), "javax.persistence." + this.info.annotationName());
        this.info.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, AbstractAnnotationElementAdapter.this.info.annotationName());
                AST ast = bodyDeclaration.getAST();
                if (annotation == null) {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                    AbstractAnnotationElementAdapter.this.addMemberValuePair(normalAnnotation, AbstractAnnotationElementAdapter.this.info.annotationElementName(), javaValue);
                    ASTTools.addAnnotation(bodyDeclaration, (Annotation)normalAnnotation);
                } else if (annotation.isNormalAnnotation()) {
                    MemberValuePair valuePair = ASTTools.getMemberValuePair((NormalAnnotation)annotation, AbstractAnnotationElementAdapter.this.getInfo().annotationElementName());
                    if (valuePair != null) {
                        valuePair.setValue(AbstractAnnotationElementAdapter.this.valuePairValue(ast, javaValue));
                    } else {
                        AbstractAnnotationElementAdapter.this.addMemberValuePair((NormalAnnotation)annotation, AbstractAnnotationElementAdapter.this.info.annotationElementName(), javaValue);
                    }
                } else {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(ast, AbstractAnnotationElementAdapter.this.info.annotationName());
                    AbstractAnnotationElementAdapter.this.addMemberValuePair(normalAnnotation, AbstractAnnotationElementAdapter.this.info.annotationElementName(), javaValue);
                    ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)normalAnnotation);
                }
            }
        });
    }

    protected MemberValuePair valuePair(CompilationUnit astRoot) {
        return ASTTools.getMemberValuePair(this.info.member().bodyDeclaration(astRoot), this.info.annotationName(), this.info.annotationElementName());
    }

    protected String javaValue(CompilationUnit astRoot) {
        MemberValuePair valuePair = this.valuePair(astRoot);
        if (valuePair != null) {
            return this.valueFromValuePair(valuePair);
        }
        return this.info.defaultValue();
    }

    protected void addMemberValuePair(NormalAnnotation normalAnnotation, String name, String javaValue) {
        AST ast = normalAnnotation.getAST();
        MemberValuePair valuePair = ast.newMemberValuePair();
        valuePair.setName(ast.newSimpleName(name));
        valuePair.setValue(this.valuePairValue(ast, javaValue));
        ASTTools.addValuePair(normalAnnotation, valuePair);
    }

    protected abstract Expression valuePairValue(AST var1, String var2);

    protected abstract String valueFromValuePair(MemberValuePair var1);

    public ITextRange getTextRange() {
        CompilationUnit astRoot = this.info.member().createASTRoot();
        return ASTTools.getTextRange((ASTNode)this.valuePair(astRoot));
    }

    public static interface AnnotationElementInfo {
        public Member member();

        public String annotationName();

        public String annotationElementName();

        public String defaultValue();

        public String persValue();

        public void setPersValue(String var1);
    }
}

