/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.RelationshipMapping;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.adapters.IJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.IJoinTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractJavaJoinColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaInverseJoinColumnInJoinTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaJoinColumnInJoinTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaTableModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;

public class JavaJoinTableModelAdapter
extends JavaTableModelAdapter
implements IJoinTableModelAdapter {
    static final String JOIN_TABLE_ANNOTATION = "JoinTable";
    static final String JOIN_COLUMNS_MEMBER = "joinColumns";
    static final String INVERSE_JOIN_COLUMNS_MEMBER = "inverseJoinColumns";

    JavaJoinTableModelAdapter() {
    }

    private AbstractJavaJoinColumnModelAdapter.JoinColumnOwner buildJoinColumnOwner() {
        return new AbstractJavaJoinColumnModelAdapter.JoinColumnOwner(){

            public RelationshipMapping relationshipMapping() {
                return (MultiRelationshipMapping)JavaJoinTableModelAdapter.this.getJoinTable().getParent();
            }

            public int index(JoinColumn joinColumn) {
                return JavaJoinTableModelAdapter.this.getJoinTable().getJoinColumns().indexOf((Object)joinColumn);
            }
        };
    }

    private AbstractJavaJoinColumnModelAdapter.JoinColumnOwner buildInverseJoinColumnOwner() {
        return new AbstractJavaJoinColumnModelAdapter.JoinColumnOwner(){

            public RelationshipMapping relationshipMapping() {
                return (MultiRelationshipMapping)JavaJoinTableModelAdapter.this.getJoinTable().getParent();
            }

            public int index(JoinColumn joinC) {
                return JavaJoinTableModelAdapter.this.getJoinTable().getInverseJoinColumns().indexOf((Object)joinC);
            }
        };
    }

    public IJoinColumnModelAdapter buildJoinColumnModelAdapter() {
        return new JavaJoinColumnInJoinTableModelAdapter(this.buildJoinColumnOwner());
    }

    public IJoinColumnModelAdapter buildInverseJoinColumnModelAdapter() {
        return new JavaInverseJoinColumnInJoinTableModelAdapter(this.buildInverseJoinColumnOwner());
    }

    public void setTable(Table table) {
        if (!(table instanceof JoinTable)) {
            throw new IllegalArgumentException();
        }
        super.setTable(table);
    }

    void updatePersModel(CompilationUnit astRoot) {
        super.updatePersModel(astRoot);
        this.updatePersDefaultJoinColumns(astRoot);
        this.updatePersDefaultInverseJoinColumns(astRoot);
        this.updatePersJoinColumns(astRoot);
        this.updatePersInverseJoinColumns(astRoot);
    }

    private void updatePersDefaultJoinColumns(CompilationUnit astRoot) {
        if (this.javaJoinColumnsSize(JOIN_COLUMNS_MEMBER) == 0) {
            if (!this.getJoinTable().isDefaultJoinColumns()) {
                this.getJoinTable().setDefaultJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultJoinColumns()) {
            this.getJoinTable().setDefaultJoinColumns(false);
        }
    }

    private void updatePersDefaultInverseJoinColumns(CompilationUnit astRoot) {
        if (this.javaJoinColumnsSize(INVERSE_JOIN_COLUMNS_MEMBER) == 0) {
            if (!this.getJoinTable().isDefaultInverseJoinColumns()) {
                this.getJoinTable().setDefaultInverseJoinColumns(true);
            }
        } else if (this.getJoinTable().isDefaultInverseJoinColumns()) {
            this.getJoinTable().setDefaultInverseJoinColumns(false);
        }
    }

    private void updatePersJoinColumns(CompilationUnit astRoot) {
        MemberValuePair outerValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, JOIN_COLUMNS_MEMBER, astRoot);
        int numJoinColumns = 0;
        if (outerValuePair != null) {
            Expression value = outerValuePair.getValue();
            if (value.getNodeType() == 77) {
                if (((NormalAnnotation)value).getTypeName().getFullyQualifiedName().equals("JoinColumn")) {
                    if (this.getJoinTable().getJoinColumns().size() <= numJoinColumns) {
                        JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                        this.getJoinTable().getJoinColumns().add((Object)joinColumn);
                        ((JavaJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                    } else {
                        ((JavaJoinColumnInJoinTableModelAdapter)((JoinColumn)this.getJoinTable().getJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                    }
                    ++numJoinColumns;
                }
            } else if (value.getNodeType() == 4) {
                Iterator i = ((ArrayInitializer)value).expressions().iterator();
                while (i.hasNext()) {
                    Expression expression = (Expression)i.next();
                    if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("JoinColumn")) continue;
                    if (this.getJoinTable().getJoinColumns().size() <= numJoinColumns) {
                        JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                        this.getJoinTable().getJoinColumns().add((Object)joinColumn);
                        ((JavaJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                    } else {
                        ((JavaJoinColumnInJoinTableModelAdapter)((JoinColumn)this.getJoinTable().getJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                    }
                    ++numJoinColumns;
                }
            }
        }
        if (numJoinColumns != 0 || this.getJoinTable().getJoinColumns().size() != 1) {
            int i = this.getJoinTable().getJoinColumns().size();
            while (i > numJoinColumns) {
                this.getJoinTable().getJoinColumns().remove(i - 1);
                --i;
            }
        }
        if (numJoinColumns == 0) {
            JoinColumn joinColumn;
            this.getJoinTable().setDefaultJoinColumns(true);
            if (this.getJoinTable().getJoinColumns().size() == 0) {
                joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
                this.getJoinTable().getJoinColumns().add((Object)joinColumn);
            } else {
                joinColumn = (JoinColumn)this.getJoinTable().getJoinColumns().get(0);
            }
            ((JavaJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
        } else {
            this.getJoinTable().setDefaultJoinColumns(false);
        }
    }

    private void updatePersInverseJoinColumns(CompilationUnit astRoot) {
        MemberValuePair outerValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, INVERSE_JOIN_COLUMNS_MEMBER, astRoot);
        int numJoinColumns = 0;
        if (outerValuePair != null) {
            Expression value = outerValuePair.getValue();
            if (value.getNodeType() == 77) {
                if (((NormalAnnotation)value).getTypeName().getFullyQualifiedName().equals("JoinColumn")) {
                    if (this.getJoinTable().getInverseJoinColumns().size() <= numJoinColumns) {
                        JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildInverseJoinColumnModelAdapter());
                        this.getJoinTable().getInverseJoinColumns().add((Object)joinColumn);
                        ((JavaInverseJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                    } else {
                        ((JavaInverseJoinColumnInJoinTableModelAdapter)((JoinColumn)this.getJoinTable().getInverseJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                    }
                    ++numJoinColumns;
                }
            } else if (value.getNodeType() == 4) {
                Iterator i = ((ArrayInitializer)value).expressions().iterator();
                while (i.hasNext()) {
                    Expression expression = (Expression)i.next();
                    if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("JoinColumn")) continue;
                    if (this.getJoinTable().getInverseJoinColumns().size() <= numJoinColumns) {
                        JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildInverseJoinColumnModelAdapter());
                        this.getJoinTable().getInverseJoinColumns().add((Object)joinColumn);
                        ((JavaInverseJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
                    } else {
                        ((JavaInverseJoinColumnInJoinTableModelAdapter)((JoinColumn)this.getJoinTable().getInverseJoinColumns().get(numJoinColumns)).getModelAdapter()).updatePersModel(astRoot);
                    }
                    ++numJoinColumns;
                }
            }
        }
        if (numJoinColumns != 0 || this.getJoinTable().getInverseJoinColumns().size() != 1) {
            int i = this.getJoinTable().getInverseJoinColumns().size();
            while (i > numJoinColumns) {
                this.getJoinTable().getInverseJoinColumns().remove(i - 1);
                --i;
            }
        }
        if (numJoinColumns == 0) {
            JoinColumn joinColumn;
            this.getJoinTable().setDefaultInverseJoinColumns(true);
            if (this.getJoinTable().getInverseJoinColumns().size() == 0) {
                joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildInverseJoinColumnModelAdapter());
                this.getJoinTable().getInverseJoinColumns().add((Object)joinColumn);
            } else {
                joinColumn = (JoinColumn)this.getJoinTable().getInverseJoinColumns().get(0);
            }
            ((JavaInverseJoinColumnInJoinTableModelAdapter)joinColumn.getModelAdapter()).updatePersModel(astRoot);
        } else {
            this.getJoinTable().setDefaultInverseJoinColumns(false);
        }
    }

    protected String annotationName() {
        return JOIN_TABLE_ANNOTATION;
    }

    private JoinTable getJoinTable() {
        return (JoinTable)this.getTable();
    }

    protected String defaultName() {
        Table owningTable = this.getMultiRelationshipMapping().getTypeMapping().getTable();
        Entity targetEntity = this.getMultiRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity != null) {
            Table table = targetEntity.getTable();
            if (owningTable != null && table != null) {
                return String.valueOf(owningTable.getName()) + "_" + table.getName();
            }
        }
        return "";
    }

    private MultiRelationshipMapping getMultiRelationshipMapping() {
        return (MultiRelationshipMapping)this.getJoinTable().eContainer();
    }

    protected Member member() {
        return ((JavaPersistentAttributeModelAdapter)this.getMultiRelationshipMapping().getPersistentAttribute().getModelAdapter()).getAttribute();
    }

    public void defaultJoinColumnsChanged() {
        if (this.javaJoinColumnsSize(JOIN_COLUMNS_MEMBER) == 0) {
            if (!this.getJoinTable().isDefaultJoinColumns()) {
                JoinColumn defaultJoinColumn = (JoinColumn)this.getJoinTable().getJoinColumns().get(0);
                defaultJoinColumn.setSpecifiedName(defaultJoinColumn.getDefaultName());
                defaultJoinColumn.setSpecifiedReferencedColumnName(defaultJoinColumn.getDefaultReferencedColumnName());
            }
        } else if (this.getJoinTable().isDefaultJoinColumns()) {
            while (this.getJoinTable().getJoinColumns().size() > 0) {
                this.getJoinTable().getJoinColumns().remove(0);
            }
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildJoinColumnModelAdapter());
            this.getJoinTable().getJoinColumns().add((Object)joinColumn);
        }
    }

    public void defaultInverseJoinColumnsChanged() {
        if (this.javaJoinColumnsSize(INVERSE_JOIN_COLUMNS_MEMBER) == 0) {
            if (!this.getJoinTable().isDefaultInverseJoinColumns()) {
                JoinColumn defaultJoinColumn = (JoinColumn)this.getJoinTable().getInverseJoinColumns().get(0);
                defaultJoinColumn.setSpecifiedName(defaultJoinColumn.getDefaultName());
                defaultJoinColumn.setSpecifiedReferencedColumnName(defaultJoinColumn.getDefaultReferencedColumnName());
            }
        } else if (this.getJoinTable().isDefaultInverseJoinColumns()) {
            while (this.getJoinTable().getInverseJoinColumns().size() > 0) {
                this.getJoinTable().getInverseJoinColumns().remove(0);
            }
            JoinColumn joinColumn = OrmFactory.eINSTANCE.createJoinColumn(this.buildInverseJoinColumnModelAdapter());
            this.getJoinTable().getInverseJoinColumns().add((Object)joinColumn);
        }
    }

    public void joinColumnAdded(JoinColumn joinColumn) {
        if (!this.getJoinTable().isDefaultJoinColumns() && this.getJoinTable().getJoinColumns().size() > this.javaJoinColumnsSize(JOIN_COLUMNS_MEMBER)) {
            this.addJoinColumnToJava(joinColumn, JOIN_COLUMNS_MEMBER);
        }
    }

    private int javaJoinColumnsSize(String joinColumnsElement) {
        MemberValuePair outerValuePair = this.member().getMemberValuePair(JOIN_TABLE_ANNOTATION, joinColumnsElement, this.member().createASTRoot());
        int numJoinColumns = 0;
        if (outerValuePair != null) {
            Expression value = outerValuePair.getValue();
            if (value.getNodeType() == 77) {
                if (((NormalAnnotation)value).getTypeName().getFullyQualifiedName().equals("JoinColumn")) {
                    ++numJoinColumns;
                }
            } else if (value.getNodeType() == 4) {
                Iterator i = ((ArrayInitializer)value).expressions().iterator();
                while (i.hasNext()) {
                    Expression expression = (Expression)i.next();
                    if (expression.getNodeType() != 77 || !((NormalAnnotation)expression).getTypeName().getFullyQualifiedName().equals("JoinColumn")) continue;
                    ++numJoinColumns;
                }
            }
        }
        return numJoinColumns;
    }

    public void joinColumnRemoved(JoinColumn joinColumn, int position) {
        int javaJoinColumnsSize = this.javaJoinColumnsSize(JOIN_COLUMNS_MEMBER);
        if (javaJoinColumnsSize == this.getJoinTable().getJoinColumns().size() || javaJoinColumnsSize == 0 && this.getJoinTable().isDefaultJoinColumns()) {
            return;
        }
        this.removeJoinColumnFromJava(joinColumn, position, JOIN_COLUMNS_MEMBER);
    }

    private void removeJoinColumnFromJava(JoinColumn joinColumn, final int position, final String joinColumnsElement) {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation joinTableAnnotation = (NormalAnnotation)ASTTools.getAnnotation(bodyDeclaration, JavaJoinTableModelAdapter.JOIN_TABLE_ANNOTATION);
                MemberValuePair outerValuePair = ASTTools.getMemberValuePair(joinTableAnnotation, joinColumnsElement);
                Expression value = outerValuePair.getValue();
                if (value.getNodeType() == 77) {
                    if (joinTableAnnotation.values().size() == 1) {
                        ASTTools.removeAnnotation(bodyDeclaration, JavaJoinTableModelAdapter.JOIN_TABLE_ANNOTATION);
                    } else {
                        ASTTools.removeValuePair(joinTableAnnotation, outerValuePair);
                    }
                } else if (value.getNodeType() == 4) {
                    if (((ArrayInitializer)value).expressions().size() == 1) {
                        if (joinTableAnnotation.values().size() == 1) {
                            ASTTools.removeAnnotation(bodyDeclaration, JavaJoinTableModelAdapter.JOIN_TABLE_ANNOTATION);
                        } else {
                            ASTTools.removeValuePair(joinTableAnnotation, outerValuePair);
                        }
                    } else {
                        ASTTools.removeFromArrayInitializer((ArrayInitializer)value, position);
                    }
                }
            }
        });
    }

    public void inverseJoinColumnAdded(JoinColumn joinColumn) {
        if (!this.getJoinTable().isDefaultInverseJoinColumns() && this.getJoinTable().getInverseJoinColumns().size() > this.javaJoinColumnsSize(INVERSE_JOIN_COLUMNS_MEMBER)) {
            this.addJoinColumnToJava(joinColumn, INVERSE_JOIN_COLUMNS_MEMBER);
        }
    }

    private void addJoinColumnToJava(JoinColumn joinColumn, final String joinColumnsElement) {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair outerValuePair = ASTTools.getMemberValuePair(bodyDeclaration, JavaJoinTableModelAdapter.JOIN_TABLE_ANNOTATION, joinColumnsElement);
                Expression value = outerValuePair.getValue();
                if (value.getNodeType() == 77) {
                    ArrayInitializer arrayInitializer = bodyDeclaration.getAST().newArrayInitializer();
                    outerValuePair.setValue((Expression)arrayInitializer);
                    ASTTools.addExpressionToArrayInitializer(arrayInitializer, value);
                    value = arrayInitializer;
                }
                if (value.getNodeType() == 4) {
                    NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "JoinColumn");
                    ASTTools.addExpressionToArrayInitializer((ArrayInitializer)value, (Expression)normalAnnotation);
                }
            }
        });
    }

    public void inverseJoinColumnRemoved(JoinColumn joinColumn, int position) {
        int javaJoinColumnsSize = this.javaJoinColumnsSize(INVERSE_JOIN_COLUMNS_MEMBER);
        if (javaJoinColumnsSize == this.getJoinTable().getInverseJoinColumns().size() || javaJoinColumnsSize == 0 && this.getJoinTable().isDefaultInverseJoinColumns()) {
            return;
        }
        this.removeJoinColumnFromJava(joinColumn, position, INVERSE_JOIN_COLUMNS_MEMBER);
    }
}

