/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.datamodels;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.packaging.PackagingFactory;
import org.eclipse.dali.packaging.PackagingResource;
import org.eclipse.dali.packaging.Persistence;
import org.eclipse.dali.packaging.PersistenceUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JPAProjectDataModelProviderOperation
extends AbstractDataModelOperation {
    public JPAProjectDataModelProviderOperation() {
    }

    public JPAProjectDataModelProviderOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        boolean createPersistenceXml = this.model.getBooleanProperty("JPAProjectDataModelProperties.CREATE_PERSISTENCE_XML");
        if (!createPersistenceXml) {
            return OK_STATUS;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.model.getStringProperty("JPAProjectDataModelProperties.PROJECT_NAME"));
        String sourceFolder = this.computeSourceFolder(project);
        URI fileURI = URI.createPlatformResourceURI((String)(String.valueOf(sourceFolder) + "/META-INF/persistence.xml"));
        PackagingResource resource = (PackagingResource)this.getResourceSet().createResource(fileURI);
        Persistence persistence = PackagingFactory.eINSTANCE.createPersistence();
        persistence.setVersion(this.model.getStringProperty("JPAProjectDataModelProperties.PERSISTENCE_VERSION"));
        PersistenceUnit pUnit = PackagingFactory.eINSTANCE.createPersistenceUnit();
        pUnit.setProvider((String)this.model.getProperty("JPAProjectDataModelProperties.PERSISTENCE_PROVIDER"));
        pUnit.setName(this.model.getStringProperty("JPAProjectDataModelProperties.PERSISTENCE_UNIT_NAME"));
        persistence.getPersistenceUnits().add((Object)pUnit);
        try {
            resource.getContents().add((Object)persistence);
            resource.save(null);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return OK_STATUS;
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }

    private String computeSourceFolder(IProject project) {
        Object[] classpath;
        IJavaProject jproject = JavaCore.create((IProject)project);
        try {
            classpath = jproject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            classpath = new IClasspathEntry[]{};
        }
        Iterator stream = CollectionTools.iterator((Object[])classpath);
        while (stream.hasNext()) {
            IClasspathEntry next = (IClasspathEntry)stream.next();
            if (next.getEntryKind() != 3) continue;
            return next.getPath().toString();
        }
        return "/" + project.getName();
    }
}

