/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.db.ui.NewConnectionWizard;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.orm.PersistenceProject;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

class DatabaseReconnectWizardPage
extends WizardPage {
    private PersistenceProject persistenceProject;
    private Connection connection;
    private ConnectionListener connectionListener;
    private DatabaseGroup databaseGroup;

    DatabaseReconnectWizardPage(PersistenceProject persistenceProject) {
        super("Database Settings");
        this.persistenceProject = persistenceProject;
        this.setTitle(DaliUiMessages.DatabaseReconnectWizardPage_databaseConnection);
        this.setMessage(DaliUiMessages.DatabaseReconnectWizardPage_reconnectToDatabase);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite top = this.createTopLevelComposite(parent);
        this.setControl((Control)top);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.databaseGroup = new DatabaseGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 30;
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2052);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    Collection getTables() {
        Schema schema = this.persistenceProject.getSchema();
        if (schema != null && schema.getName() != null) {
            return CollectionTools.collection((Iterator)schema.tables());
        }
        return new ArrayList();
    }

    private void updateGenerateEntitiesPage(Schema schema) {
        GenerateEntitiesWizard generateEntitiesWizard = (GenerateEntitiesWizard)this.getWizard();
        generateEntitiesWizard.updatePossibleTables(CollectionTools.collection((Iterator)schema.tables()));
    }

    public void dispose() {
        this.removeConnectionListener();
        super.dispose();
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            if (this.connection != null) {
                this.connection.removeConnectionListener(this.connectionListener);
            }
            this.connectionListener = null;
        }
    }

    private final class DatabaseGroup {
        private final Group group;
        private final Label connectionLabel;
        private final Combo connectionCombo;
        private final Label schemaLabel;
        private final Combo schemaCombo;
        private final Label schemaInfoLabel;
        private Link addConnectionLink;
        private Link reconnectLink;

        public DatabaseGroup(Composite composite) {
            this.group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setText(DaliUiMessages.DatabaseReconnectWizardPage_database);
            this.connectionLabel = DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.DatabaseReconnectWizardPage_connection);
            this.connectionCombo = DatabaseReconnectWizardPage.this.createCombo((Composite)this.group, true);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$0(this.this$1);
                }
            });
            this.schemaLabel = DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 1, DaliUiMessages.DatabaseReconnectWizardPage_schema);
            this.schemaCombo = DatabaseReconnectWizardPage.this.createCombo((Composite)this.group, true);
            this.schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$1(this.this$1);
                }
            });
            this.schemaInfoLabel = DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 2, DaliUiMessages.DatabaseReconnectWizardPage_schemaInfo);
            this.addConnectionLink = new Link((Composite)this.group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.addConnectionLink.setLayoutData((Object)data);
            this.addConnectionLink.setText(DaliUiMessages.DatabaseReconnectWizardPage_addConnectionLink);
            this.addConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$2(this.this$1);
                }
            });
            this.reconnectLink = new Link((Composite)this.group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.reconnectLink.setLayoutData((Object)data);
            this.reconnectLink.setText(DaliUiMessages.DatabaseReconnectWizardPage_reconnectLink);
            this.reconnectLink.setEnabled(false);
            this.reconnectLink.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DatabaseGroup this$1;
                {
                    this.this$1 = databaseGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.access$4(this.this$1, DatabaseGroup.access$3(this.this$1).getText());
                }
            });
            this.populateConnectionCombo();
            this.populateSchemaCombo();
        }

        private Connection openConnectionNamed(String connectionName) {
            if (DatabaseReconnectWizardPage.this.connection != null) {
                DatabaseReconnectWizardPage.this.removeConnectionListener();
            }
            DatabaseReconnectWizardPage.this.connection = PersistenceDbPlugin.getDefault().getConnectionRepository().openConnectionNamed(connectionName);
            if (DatabaseReconnectWizardPage.this.connection != null) {
                this.populateSchemaCombo();
                DatabaseReconnectWizardPage.this.connectionListener = this.buildConnectionListener(DatabaseReconnectWizardPage.this.connection);
                DatabaseReconnectWizardPage.this.connection.addConnectionListener(DatabaseReconnectWizardPage.this.connectionListener);
            }
            return DatabaseReconnectWizardPage.this.connection;
        }

        private void populateConnectionCombo() {
            this.connectionCombo.removeAll();
            Iterator i = CollectionTools.sort((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames());
            while (i.hasNext()) {
                this.connectionCombo.add((String)i.next());
            }
            String connectionName = DatabaseReconnectWizardPage.this.persistenceProject.getConnectionName();
            if (!StringTools.stringIsEmpty((String)connectionName)) {
                this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
                this.reconnectLink.setEnabled(true);
            }
        }

        private void handleConnectionChange() {
            this.reconnectLink.setEnabled(true);
            this.populateSchemaCombo();
        }

        private void handleSchemaChange() {
            Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.getConnectionName());
            Schema schema = connection.getDatabase().schemaNamed(this.getSchemaName());
            DatabaseReconnectWizardPage.this.updateGenerateEntitiesPage(schema);
            DatabaseReconnectWizardPage.this.setPageComplete(true);
        }

        private void populateSchemaCombo() {
            this.schemaCombo.removeAll();
            Connection connection = PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNamed(this.getConnectionName());
            Iterator stream = CollectionTools.sort((Iterator)connection.getDatabase().schemaNames());
            while (stream.hasNext()) {
                this.schemaCombo.add((String)stream.next());
            }
            Schema schema = DatabaseReconnectWizardPage.this.persistenceProject.getSchema();
            if (schema != null && schema.getName() != null && (schema = connection.getDatabase().schemaNamed(schema.getName())) != null) {
                this.schemaCombo.select(this.schemaCombo.indexOf(schema.getName()));
                DatabaseReconnectWizardPage.this.updateGenerateEntitiesPage(schema);
                DatabaseReconnectWizardPage.this.setPageComplete(true);
            }
        }

        private String getConnectionName() {
            return this.connectionCombo.getText();
        }

        private String getSchemaName() {
            return this.schemaCombo.getText();
        }

        private void openNewConnectionWizard() {
            NewConnectionWizard wizard = new NewConnectionWizard(true);
            wizard.setExistingConnectionNames(CollectionTools.list((Iterator)PersistenceDbPlugin.getDefault().getConnectionRepository().connectionNames()));
            wizard.init(PlatformUI.getWorkbench(), null);
            wizard.setNeedsProgressMonitor(true);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
            Connection connection = wizard.getConnectionWrapper();
            if (connection != null) {
                this.populateConnectionCombo();
                this.connectionCombo.select(this.connectionCombo.indexOf(connection.getName()));
                this.handleConnectionChange();
            }
        }

        private ConnectionListener buildConnectionListener(Connection connectionInfo) {
            return new ConnectionListener(this, connectionInfo){
                final /* synthetic */ DatabaseGroup this$1;
                private final /* synthetic */ Connection val$connectionInfo;
                {
                    this.this$1 = databaseGroup;
                    this.val$connectionInfo = connection;
                }

                public void connectionInfoRenamed(String previousName, Connection connection) {
                }

                public void connected(Connection connection) {
                }

                public void disconnected(Connection connection) {
                }

                public void sharedConnectionAdded(Connection connection) {
                }

                public void sharedConnectionRemove(Connection connection) {
                }

                public void schemaChanged(Schema schema) {
                }

                public void tableChanged(Table table) {
                }

                public void databaseAdded(Connection connection, Database database) {
                    if (this.val$connectionInfo.equals(connection)) {
                        DatabaseGroup.access$5(this.this$1);
                    }
                }

                public void databaseRemove(Connection connection, Database database) {
                    if (this.val$connectionInfo.equals(connection)) {
                        DatabaseReconnectWizardPage.access$3(DatabaseGroup.access$6(this.this$1));
                    }
                }

                public void onSQLException(Connection connection, SQLException exception) {
                    this.val$connectionInfo.equals(connection);
                }
            };
        }

        static /* synthetic */ void access$0(DatabaseGroup databaseGroup) {
            databaseGroup.handleConnectionChange();
        }

        static /* synthetic */ void access$1(DatabaseGroup databaseGroup) {
            databaseGroup.handleSchemaChange();
        }

        static /* synthetic */ void access$2(DatabaseGroup databaseGroup) {
            databaseGroup.openNewConnectionWizard();
        }

        static /* synthetic */ Combo access$3(DatabaseGroup databaseGroup) {
            return databaseGroup.connectionCombo;
        }

        static /* synthetic */ Connection access$4(DatabaseGroup databaseGroup, String string) {
            return databaseGroup.openConnectionNamed(string);
        }

        static /* synthetic */ void access$5(DatabaseGroup databaseGroup) {
            databaseGroup.populateSchemaCombo();
        }

        static /* synthetic */ DatabaseReconnectWizardPage access$6(DatabaseGroup databaseGroup) {
            return databaseGroup.DatabaseReconnectWizardPage.this;
        }
    }
}

