/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.Transformer;
import org.eclipse.dali.internal.utility.iterators.TransformationListIterator;

public class TransformationListIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TransformationListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.TransformationListIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public TransformationListIteratorTests(String name) {
        super(name);
    }

    public void testHasNextAndHasPrevious() {
        int i = 0;
        ListIterator stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationListIteratorTests.assertEquals((int)8, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        TransformationListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testInnerHasNextAndHasPrevious() {
        int i = 0;
        ListIterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        TransformationListIteratorTests.assertEquals((int)8, (int)i);
        while (stream.hasPrevious()) {
            stream.previous();
            --i;
        }
        TransformationListIteratorTests.assertEquals((int)0, (int)i);
    }

    public void testNextAndPrevious() {
        int i = 0;
        ListIterator stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)((Integer)stream.next()));
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(--i), (int)((Integer)stream.previous()));
        }
    }

    public void testInnerNextAndPrevious() {
        int i = 0;
        ListIterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)((Integer)stream.next()));
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(--i), (int)((Integer)stream.previous()));
        }
    }

    public void testNextIndexAndPreviousIndex() {
        int i = -1;
        ListIterator stream = this.buildIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)stream.nextIndex());
            stream.next();
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(--i), (int)stream.previousIndex());
            stream.previous();
        }
    }

    public void testInnerNextIndexAndPreviousIndex() {
        int i = -1;
        ListIterator stream = this.buildInnerIterator();
        while (stream.hasNext()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(++i), (int)stream.nextIndex());
            stream.next();
        }
        ++i;
        while (stream.hasPrevious()) {
            TransformationListIteratorTests.assertEquals((String)"bogus transformation", (int)(--i), (int)stream.previousIndex());
            stream.previous();
        }
    }

    public void testRemove() {
        List l = this.buildList();
        ListIterator stream = this.buildInnerTransformationListIterator(l.listIterator());
        while (stream.hasNext()) {
            if ((Integer)stream.next() != 3) continue;
            stream.remove();
        }
        TransformationListIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildList().size() - 1), (int)l.size());
        TransformationListIteratorTests.assertFalse((String)"element still in list", (boolean)l.contains("333"));
        TransformationListIteratorTests.assertTrue((String)"wrong element removed", (boolean)l.contains("22"));
    }

    public void testInnerRemove() {
        List l = this.buildList();
        ListIterator stream = this.buildTransformationListIterator(l.listIterator(), this.buildTransformer());
        while (stream.hasNext()) {
            if ((Integer)stream.next() != 3) continue;
            stream.remove();
        }
        TransformationListIteratorTests.assertEquals((String)"nothing removed", (int)(this.buildList().size() - 1), (int)l.size());
        TransformationListIteratorTests.assertFalse((String)"element still in list", (boolean)l.contains("333"));
        TransformationListIteratorTests.assertTrue((String)"wrong element removed", (boolean)l.contains("22"));
    }

    public void testUnsupportedOperationExceptionOnAdd() {
        ListIterator stream = this.buildIterator();
        boolean exCaught = false;
        try {
            stream.add("0");
            TransformationListIteratorTests.fail((String)"exception not thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testUnsupportedOperationExceptionOnSet() {
        ListIterator stream = this.buildIterator();
        boolean exCaught = false;
        try {
            stream.set("0");
            TransformationListIteratorTests.fail((String)"exception not thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((boolean)exCaught);
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        ListIterator stream = this.buildIterator();
        Integer integer = null;
        while (stream.hasNext()) {
            integer = (Integer)stream.next();
        }
        try {
            integer = (Integer)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + integer), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        ListIterator stream = this.buildUnmodifiableIterator();
        while (stream.hasNext()) {
            int i = (Integer)stream.next();
            if (i != 3) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        TransformationListIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalStateException() {
        boolean exCaught = false;
        try {
            this.buildIterator().remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        TransformationListIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    private ListIterator buildIterator() {
        return this.buildTransformationListIterator(this.buildNestedIterator(), this.buildTransformer());
    }

    private ListIterator buildInnerIterator() {
        return this.buildInnerTransformationListIterator(this.buildNestedIterator());
    }

    private ListIterator buildUnmodifiableIterator() {
        return this.buildTransformationListIterator(this.buildUnmodifiableNestedIterator(), this.buildTransformer());
    }

    private ListIterator buildTransformationListIterator(ListIterator nestedIterator, Transformer transformer) {
        return new TransformationListIterator(nestedIterator, transformer);
    }

    private Transformer buildTransformer() {
        return new Transformer(){

            public Object transform(Object next) {
                return new Integer(((String)next).length());
            }
        };
    }

    private ListIterator buildInnerTransformationListIterator(ListIterator nestedIterator) {
        return new TransformationListIterator(nestedIterator){

            protected Object transform(Object next) {
                return new Integer(((String)next).length());
            }
        };
    }

    private ListIterator buildNestedIterator() {
        return this.buildList().listIterator();
    }

    private ListIterator buildUnmodifiableNestedIterator() {
        return this.buildUnmodifiableList().listIterator();
    }

    private List buildList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        l.add("22");
        l.add("333");
        l.add("4444");
        l.add("55555");
        l.add("666666");
        l.add("7777777");
        l.add("88888888");
        return l;
    }

    private List buildUnmodifiableList() {
        return Collections.unmodifiableList(this.buildList());
    }
}

