import type tsp from 'typescript/lib/protocol.d.js';
import { ServerResponse } from './requests.js';
export interface CallbackItem<R> {
    readonly onSuccess: (value: R) => void;
    readonly onError: (err: Error) => void;
    readonly queuingStartTime: number;
    readonly isAsync: boolean;
}
export declare class CallbackMap<R extends tsp.Response> {
    private readonly _callbacks;
    private readonly _asyncCallbacks;
    destroy(cause: string): void;
    add(seq: number, callback: CallbackItem<ServerResponse.Response<R> | undefined>, isAsync: boolean): void;
    fetch(seq: number): CallbackItem<ServerResponse.Response<R> | undefined> | undefined;
    private delete;
}
//# sourceMappingURL=callbackMap.d.ts.map