(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "../parser/cssNodes"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var cssNodes_1 = require("../parser/cssNodes");
    function getSelectionRanges(document, position, stylesheet) {
        var applicableRanges = getApplicableRanges(document, position, stylesheet);
        var ranges = applicableRanges.map(function (pair) {
            return vscode_languageserver_types_1.Range.create(document.positionAt(pair[0]), document.positionAt(pair[1]));
        });
        return ranges;
    }
    exports.getSelectionRanges = getSelectionRanges;
    function getApplicableRanges(document, position, stylesheet) {
        var currNode = stylesheet.findChildAtOffset(document.offsetAt(position), true);
        if (!currNode) {
            return [];
        }
        var result = [];
        while (currNode) {
            if (currNode.parent &&
                currNode.offset === currNode.parent.offset &&
                currNode.end === currNode.parent.end) {
                currNode = currNode.parent;
                continue;
            }
            if (currNode.type === cssNodes_1.NodeType.Declarations) {
                result.push([currNode.offset + 1, currNode.end - 1]);
            }
            else {
                result.push([currNode.offset, currNode.end]);
            }
            currNode = currNode.parent;
        }
        return result;
    }
    exports.getApplicableRanges = getApplicableRanges;
});
//# sourceMappingURL=cssSelectionRange.js.map