"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
const vscode_html_languageservice_1 = require("vscode-html-languageservice");
function register(htmlLs) {
    const docForEmptyLineCompletion = vscode_html_languageservice_1.TextDocument.create('file:///foo.html', 'html', 0, '< />');
    const htmlDocForEmptyLineCompletion = htmlLs.parseHTMLDocument(docForEmptyLineCompletion);
    const posForEmptyLine = docForEmptyLineCompletion.positionAt(1);
    return async (pugDoc, pos, documentContext, options) => {
        const offset = pugDoc.pugTextDocument.offsetAt(pos);
        if (pugDoc.emptyLineEnds.includes(offset)) {
            const htmlComplete = htmlLs.doComplete(docForEmptyLineCompletion, posForEmptyLine, htmlDocForEmptyLineCompletion, options);
            for (const item of htmlComplete.items) {
                item.textEdit = undefined;
            }
            return htmlComplete;
        }
        const htmlPos = pugDoc.map.toGeneratedPosition(pos);
        if (!htmlPos)
            return;
        const htmlComplete = documentContext ? await htmlLs.doComplete2(pugDoc.htmlTextDocument, htmlPos, pugDoc.htmlDocument, documentContext, options) : htmlLs.doComplete(pugDoc.htmlTextDocument, htmlPos, pugDoc.htmlDocument, options);
        return language_service_1.transformer.asCompletionList(htmlComplete, htmlRange => pugDoc.map.toSourceRange(htmlRange), pugDoc.map.virtualFileDocument);
    };
}
exports.register = register;
//# sourceMappingURL=completion.js.map