/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;

public class RenderingsUtil {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    public static final int ENDIANESS_UNKNOWN = 2;

    protected static byte[] fillArray(byte[] array, int size, int endianess) {
        if (endianess == 0) {
            byte[] temp = new byte[size];
            int i = 0;
            while (i < array.length) {
                temp[i] = array[i];
                ++i;
            }
            i = array.length;
            while (i < size) {
                temp[i] = 0;
                ++i;
            }
            array = temp;
            return array;
        }
        byte[] temp = new byte[size];
        int i = 0;
        while (i < size - array.length) {
            temp[i] = 0;
            ++i;
        }
        int j = 0;
        int i2 = size - array.length;
        while (i2 < size) {
            temp[i2] = array[j];
            ++j;
            ++i2;
        }
        array = temp;
        return array;
    }

    public static BigInteger convertByteArrayToUnsignedLong(byte[] array, int endianess, int addressableSize) {
        if (array.length < 8) {
            array = RenderingsUtil.fillArray(array, 8, endianess);
        }
        BigInteger value = BigInteger.ZERO;
        if (endianess == 0) {
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < addressableSize) {
                    byte[] temp = new byte[]{array[i + j]};
                    BigInteger b = new BigInteger(temp);
                    b = b.and(new BigInteger("ff", 16));
                    b = b.shiftLeft((i + addressableSize - j - 1) * 8);
                    value = value.or(b);
                    ++j;
                }
                i += addressableSize;
            }
        } else {
            int i = 0;
            while (i < 8) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((7 - i) * 8);
                value = value.or(b);
                ++i;
            }
        }
        return value;
    }

    public static long convertByteArrayToLong(byte[] array, int endianess, int addressableSize) {
        if (array.length < 8) {
            array = RenderingsUtil.fillArray(array, 8, endianess);
        }
        if (endianess == 0) {
            long value = 0L;
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < addressableSize) {
                    long b = array[i + j];
                    value |= (b &= 0xFFL) << (i + addressableSize - j - 1) * 8;
                    ++j;
                }
                i += addressableSize;
            }
            return value;
        }
        long value = 0L;
        int i = 0;
        while (i < 8) {
            long b = array[i];
            value |= (b &= 0xFFL) << (7 - i) * 8;
            ++i;
        }
        return value;
    }

    public static BigInteger convertByteArrayToSignedBigInt(byte[] array, int endianess, int addressableSize) {
        if (array.length < 16) {
            array = RenderingsUtil.fillArray(array, 16, endianess);
        }
        if (endianess == 0) {
            byte[] holder = new byte[16];
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < addressableSize) {
                    holder[i + j] = array[16 + j - i - addressableSize];
                    ++j;
                }
                i += addressableSize;
            }
            BigInteger value = new BigInteger(holder);
            return value;
        }
        BigInteger value = new BigInteger(array);
        return value;
    }

    public static BigInteger convertByteArrayToSignedBigInt(byte[] array, int endianess, int arraySize, int addressableSize) {
        if (array.length < arraySize) {
            array = RenderingsUtil.fillArray(array, arraySize, endianess);
        }
        if (endianess == 0) {
            byte[] holder = new byte[arraySize];
            int i = 0;
            while (i < arraySize) {
                int j = 0;
                while (j < addressableSize) {
                    holder[i + j] = array[arraySize + j - i - addressableSize];
                    ++j;
                }
                i += addressableSize;
            }
            BigInteger value = new BigInteger(holder);
            return value;
        }
        BigInteger value = new BigInteger(array);
        return value;
    }

    public static BigInteger convertByteArrayToUnsignedBigInt(byte[] array, int endianess, int addressableSize) {
        if (array.length < 16) {
            array = RenderingsUtil.fillArray(array, 16, endianess);
        }
        BigInteger value = BigInteger.ZERO;
        if (endianess == 0) {
            int i = 0;
            while (i < 16) {
                int j = 0;
                while (j < addressableSize) {
                    byte[] temp = new byte[]{array[i + j]};
                    BigInteger b = new BigInteger(temp);
                    b = b.and(new BigInteger("ff", 16));
                    b = b.shiftLeft((i + addressableSize - j - 1) * 8);
                    value = value.or(b);
                    ++j;
                }
                i += addressableSize;
            }
        } else {
            int i = 0;
            while (i < 16) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((15 - i) * 8);
                value = value.or(b);
                ++i;
            }
        }
        return value;
    }

    public static BigInteger convertByteArrayToUnsignedBigInt(byte[] array, int endianess, int arraySize, int addressableSize) {
        if (array.length < arraySize) {
            array = RenderingsUtil.fillArray(array, arraySize, endianess);
        }
        BigInteger value = BigInteger.ZERO;
        if (endianess == 0) {
            int i = 0;
            while (i < arraySize) {
                int j = 0;
                while (j < addressableSize) {
                    byte[] temp = new byte[]{array[i + j]};
                    BigInteger b = new BigInteger(temp);
                    b = b.and(new BigInteger("ff", 16));
                    b = b.shiftLeft((i + addressableSize - j - 1) * 8);
                    value = value.or(b);
                    ++j;
                }
                i += addressableSize;
            }
        } else {
            int i = 0;
            while (i < arraySize) {
                byte[] temp = new byte[]{array[i]};
                BigInteger b = new BigInteger(temp);
                b = b.and(new BigInteger("ff", 16));
                b = b.shiftLeft((arraySize - 1 - i) * 8);
                value = value.or(b);
                ++i;
            }
        }
        return value;
    }

    public static int convertByteArrayToInt(byte[] array, int endianess, int addressableSize) {
        if (array.length < 4) {
            array = RenderingsUtil.fillArray(array, 4, endianess);
        }
        if (endianess == 0) {
            int value = 0;
            int i = 0;
            while (i < 4) {
                int j = 0;
                while (j < addressableSize) {
                    int b = array[i + j];
                    value |= (b &= 0xFF) << (i + addressableSize - j - 1) * 8;
                    ++j;
                }
                i += addressableSize;
            }
            return value;
        }
        int value = 0;
        int i = 0;
        while (i < 4) {
            int b = array[i];
            value |= (b &= 0xFF) << (3 - i) * 8;
            ++i;
        }
        return value;
    }

    public static short convertByteArrayToShort(byte[] array, int endianess, int addressableSize) {
        if (array.length < 2) {
            array = RenderingsUtil.fillArray(array, 2, endianess);
        }
        if (endianess == 0) {
            short value = 0;
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < addressableSize) {
                    short b = array[i + j];
                    b = (short)(b & 0xFF);
                    value = (short)(value | b << (i + addressableSize - j - 1) * 8);
                    ++j;
                }
                i += addressableSize;
            }
            return value;
        }
        short value = 0;
        int i = 0;
        while (i < 2) {
            short b = array[i];
            b = (short)(b & 0xFF);
            value = (short)(value | b << (1 - i) * 8);
            ++i;
        }
        return value;
    }

    public static byte[] convertBigIntegerToByteArray(BigInteger i, int endianess, int addressableSize) {
        byte[] buf = new byte[16];
        if (endianess == 0) {
            int j = 0;
            while (j < 16) {
                int k = 0;
                while (k < addressableSize) {
                    BigInteger x = i.shiftRight((j + addressableSize - k - 1) * 8);
                    buf[j + k] = x.byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = 15;
        while (j >= 0) {
            BigInteger x = i.shiftRight((15 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertSignedBigIntToByteArray(BigInteger i, int endianess, int arraySize, int addressableSize) {
        byte[] buf = new byte[arraySize];
        if (endianess == 0) {
            int j = 0;
            while (j < arraySize) {
                int k = 0;
                while (k < addressableSize) {
                    BigInteger x = i.shiftRight((j + addressableSize - k - 1) * 8);
                    buf[j + k] = x.byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = arraySize - 1;
        while (j >= 0) {
            BigInteger x = i.shiftRight((arraySize - 1 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertUnsignedBigIntegerToByteArray(BigInteger i, int endianess, int addressableSize) {
        byte[] buf = new byte[32];
        if (endianess == 0) {
            int j = 0;
            while (j < 32) {
                int k = 0;
                while (k < addressableSize) {
                    BigInteger x = i.shiftRight((j + addressableSize - k - 1) * 8);
                    buf[j + k] = x.byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = 31;
        while (j >= 0) {
            BigInteger x = i.shiftRight((31 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertUnsignedBigIntToByteArray(BigInteger i, int endianess, int arraySize, int addressableSize) {
        byte[] buf = new byte[arraySize * 2];
        if (endianess == 0) {
            int j = 0;
            while (j < arraySize * 2) {
                int k = 0;
                while (k < addressableSize) {
                    BigInteger x = i.shiftRight((j + addressableSize - k - 1) * 8);
                    buf[j + k] = x.byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = arraySize * 2 - 1;
        while (j >= 0) {
            BigInteger x = i.shiftRight((arraySize * 2 - 1 - j) * 8);
            buf[j] = x.byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertLongToByteArray(long i, int endianess, int addressableSize) {
        byte[] buf = new byte[8];
        if (endianess == 0) {
            int j = 0;
            while (j < 8) {
                int k = 0;
                while (k < addressableSize) {
                    buf[j + k] = Long.valueOf(i >> (j + addressableSize - k - 1) * 8).byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = 7;
        while (j >= 0) {
            buf[j] = Long.valueOf(i >> (7 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertIntToByteArray(int i, int endianess, int addressableSize) {
        byte[] buf = new byte[4];
        if (endianess == 0) {
            int j = 0;
            while (j < 4) {
                int k = 0;
                while (k < addressableSize) {
                    buf[j + k] = Integer.valueOf(i >> (j + addressableSize - k - 1) * 8).byteValue();
                    ++k;
                }
                j += addressableSize;
            }
            return buf;
        }
        int j = 3;
        while (j >= 0) {
            buf[j] = Integer.valueOf(i >> (3 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    public static byte[] convertShortToByteArray(short i, int endianess, int addressableSize) {
        byte[] buf = new byte[2];
        if (endianess == 0) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < addressableSize) {
                    buf[j + k] = Integer.valueOf(i >> (j + addressableSize - k - 1) * 8).byteValue();
                    ++k;
                }
                j = (short)(j + addressableSize);
            }
            return buf;
        }
        int j = 1;
        while (j >= 0) {
            buf[j] = Integer.valueOf(i >> (1 - j) * 8).byteValue();
            j = (short)(j - 1);
        }
        return buf;
    }

    public static String convertByteArrayToHexString(byte[] byteArray) {
        StringBuilder strBuffer = new StringBuilder();
        byte[] byArray = byteArray;
        int n = byteArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            char[] charArray = RenderingsUtil.convertByteToCharArray(element);
            strBuffer.append(charArray);
            ++n2;
        }
        return strBuffer.toString();
    }

    public static char[] convertByteToCharArray(byte aByte) {
        char[] charArray = new char[2];
        int val = aByte;
        if (val < 0) {
            val += 256;
        }
        charArray[0] = Character.forDigit(val / 16, 16);
        charArray[1] = Character.forDigit(val % 16, 16);
        return charArray;
    }

    public static byte[] convertHexStringToByteArray(String str, int numBytes, int numCharsPerByte) throws NumberFormatException {
        if (str.length() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(str);
        int requiredPadding = numBytes * numCharsPerByte - str.length();
        while (requiredPadding > 0) {
            buf.insert(0, "0");
            --requiredPadding;
        }
        byte[] bytes = new byte[numBytes];
        str = buf.toString();
        int i = 0;
        while (i < bytes.length) {
            String oneByte = str.substring(i * 2, i * 2 + 2);
            Integer number = Integer.valueOf(oneByte, 16);
            if (number.compareTo(Integer.valueOf(Byte.toString((byte)127))) > 0) {
                int temp = number;
                String tempStr = Integer.toString(temp -= 256);
                Byte myByte = Byte.valueOf(tempStr);
                bytes[i] = myByte;
            } else {
                Byte myByte = Byte.valueOf(oneByte, 16);
                bytes[i] = myByte;
            }
            ++i;
        }
        return bytes;
    }
}

