"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startLanguageServer = exports.createConnection = void 0;
const vscode = require("vscode-languageserver/browser");
const server_1 = require("../common/server");
const http_1 = require("../common/schemaRequestHandlers/http");
const vscode_uri_1 = require("vscode-uri");
const protocol_1 = require("../protocol");
const language_service_1 = require("@volar/language-service");
__exportStar(require("../index"), exports);
function createConnection() {
    const messageReader = new vscode.BrowserMessageReader(self);
    const messageWriter = new vscode.BrowserMessageWriter(self);
    const connection = vscode.createConnection(messageReader, messageWriter);
    return connection;
}
exports.createConnection = createConnection;
function startLanguageServer(connection, ...plugins) {
    (0, server_1.startCommonLanguageServer)(connection, plugins, () => ({
        uriToFileName,
        fileNameToUri,
        console: connection.console,
        timer: {
            setImmediate(callback, ...args) {
                const handle = setTimeout(callback, 0, ...args);
                return { dispose: () => clearTimeout(handle) };
            },
        },
        async loadTypeScript(options) {
            const tsdkUri = options.typescript && 'tsdkUrl' in options.typescript
                ? options.typescript.tsdkUrl
                : undefined;
            if (!tsdkUri) {
                return;
            }
            const _module = globalThis.module;
            globalThis.module = { exports: {} };
            await import(`${tsdkUri}/lib/typescript.js`);
            const ts = globalThis.module.exports;
            globalThis.module = _module;
            return ts;
        },
        async loadTypeScriptLocalized(options, locale) {
            const tsdkUri = options.typescript && 'tsdkUrl' in options.typescript
                ? options.typescript.tsdkUrl
                : undefined;
            if (!tsdkUri) {
                return;
            }
            try {
                const uri = fileNameToUri(`${tsdkUri}/${locale}/diagnosticMessages.generated.json`);
                const json = await (0, http_1.default)(uri);
                if (json) {
                    return JSON.parse(json);
                }
            }
            catch { }
        },
        fs: createFs(connection),
        getCancellationToken(original) {
            return original ?? vscode.CancellationToken.None;
        },
    }));
}
exports.startLanguageServer = startLanguageServer;
/**
 * To avoid hitting the API hourly limit, we keep requests as low as possible.
 */
function createFs(connection) {
    const readDirectoryResults = new Map();
    return {
        async stat(uri) {
            if (uri.startsWith('__invalid__:')) {
                return;
            }
            if (uri.startsWith('http://') || uri.startsWith('https://')) {
                const text = await this.readFile(uri); // TODO: perf
                if (text !== undefined) {
                    return {
                        type: language_service_1.FileType.File,
                        size: text.length,
                        ctime: -1,
                        mtime: -1,
                    };
                }
                return undefined;
            }
            const dirUri = uri.substring(0, uri.lastIndexOf('/'));
            const baseName = uri.substring(uri.lastIndexOf('/') + 1);
            const entries = await this.readDirectory(dirUri);
            const matches = entries.filter(entry => entry[0] === baseName);
            if (matches.length) {
                return {
                    type: matches.some(entry => entry[1] === language_service_1.FileType.File) ? language_service_1.FileType.File : matches[0][1],
                    size: -1,
                    ctime: -1,
                    mtime: -1,
                };
            }
        },
        async readFile(uri) {
            if (uri.startsWith('__invalid__:')) {
                return;
            }
            if (uri.startsWith('http://') || uri.startsWith('https://')) {
                return await (0, http_1.default)(uri);
            }
            const dirUri = uri.substring(0, uri.lastIndexOf('/'));
            const baseName = uri.substring(uri.lastIndexOf('/') + 1);
            const entries = await this.readDirectory(dirUri);
            const file = entries.filter(entry => entry[0] === baseName && entry[1] === language_service_1.FileType.File);
            if (file) {
                const text = await connection.sendRequest(protocol_1.FsReadFileRequest.type, uri);
                if (text !== undefined && text !== null) {
                    return text;
                }
            }
        },
        async readDirectory(uri) {
            if (uri.startsWith('__invalid__:')) {
                return [];
            }
            if (uri.startsWith('http://') || uri.startsWith('https://')) {
                return [];
            }
            if (!readDirectoryResults.has(uri)) {
                readDirectoryResults.set(uri, connection.sendRequest(protocol_1.FsReadDirectoryRequest.type, uri));
            }
            return await readDirectoryResults.get(uri);
        },
    };
}
function uriToFileName(uri) {
    const parsed = vscode_uri_1.URI.parse(uri);
    if (parsed.scheme === '__invalid__') {
        return parsed.path;
    }
    return `/${parsed.scheme}${parsed.authority ? '@' + parsed.authority : ''}${parsed.path}`;
}
function fileNameToUri(fileName) {
    const parts = fileName.split('/');
    if (parts.length <= 1) {
        return vscode_uri_1.URI.from({
            scheme: '__invalid__',
            path: fileName,
        }).toString();
    }
    const firstParts = parts[1].split('@');
    return vscode_uri_1.URI.from({
        scheme: firstParts[0],
        authority: firstParts.length > 1 ? firstParts[1] : undefined,
        path: '/' + parts.slice(2).join('/'),
    }).toString();
}
//# sourceMappingURL=index.js.map