/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.chrome;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;

public class ChromeExecutableTab
extends AbstractLaunchConfigurationTab {
    private ComboViewer browserToUse;
    private Image image;
    private List<Object> proposals;

    public ChromeExecutableTab() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream imageResource = ((Object)((Object)this)).getClass().getResourceAsStream("/icons/ChromeIcon.png");){
                this.image = new Image((Device)Display.getDefault(), imageResource);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(2, false));
        new Label(res, 0).setText(Messages.ChromeAttachTab_runWith);
        this.browserToUse = new ComboViewer(res, 2572);
        this.browserToUse.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.browserToUse.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        this.proposals = new LinkedList<Object>();
        this.proposals.add("");
        this.proposals.addAll(BrowserManager.getInstance().getWebBrowsers().stream().filter(ChromeExecutableTab::isChrome).toList());
        this.browserToUse.setInput(this.proposals);
        this.browserToUse.addPostSelectionChangedListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Link link = new Link(res, 0);
        link.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        link.setText(Messages.ChromeAttachTab_browserPreferences);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)"org.eclipse.ui.browser.preferencePage", null, null);
            dialog.open();
            List<IBrowserDescriptor> previous = this.proposals.stream().filter(IBrowserDescriptor.class::isInstance).map(IBrowserDescriptor.class::cast).toList();
            List next = BrowserManager.getInstance().getWebBrowsers();
            LinkedList<IBrowserDescriptor> toRemove = new LinkedList<IBrowserDescriptor>(previous);
            toRemove.removeAll(next);
            this.proposals.removeAll(toRemove);
            LinkedList<IBrowserDescriptor> toAdd = new LinkedList<IBrowserDescriptor>(next);
            toAdd.removeAll(previous);
            toAdd.removeIf(browser -> !ChromeExecutableTab.isChrome(browser));
            this.proposals.addAll(toAdd);
            if (!toAdd.isEmpty() || !toRemove.isEmpty()) {
                this.browserToUse.refresh();
                if (this.browserToUse.getSelection().isEmpty()) {
                    this.browserToUse.setSelection((ISelection)new StructuredSelection((Object)""));
                }
            }
        }));
        this.setControl((Control)res);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.removeAttribute("runtimeExecutable");
    }

    public static boolean isChrome(IBrowserDescriptor desc) {
        return desc != null && (desc.getName().toLowerCase().contains("chrom") || desc.getLocation() != null && desc.getLocation().toLowerCase().contains("chrom"));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String browserLocation = configuration.getAttribute("runtimeExecutable", "");
            if (browserLocation.isEmpty()) {
                this.browserToUse.setSelection((ISelection)new StructuredSelection((Object)browserLocation));
            } else {
                Optional<IBrowserDescriptor> desc = this.proposals.stream().filter(IBrowserDescriptor.class::isInstance).map(IBrowserDescriptor.class::cast).filter(it -> browserLocation.equals(it.getLocation())).findFirst();
                if (desc.isPresent()) {
                    desc.ifPresent(it -> this.browserToUse.setSelection((ISelection)new StructuredSelection(it)));
                } else {
                    if (!this.proposals.contains(browserLocation)) {
                        this.proposals.add(browserLocation);
                    }
                    this.browserToUse.refresh();
                    this.browserToUse.setSelection((ISelection)new StructuredSelection((Object)browserLocation));
                }
            }
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log(ex.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object selectedBrowser = ((IStructuredSelection)this.browserToUse.getSelection()).getFirstElement();
        if (selectedBrowser instanceof IBrowserDescriptor) {
            IBrowserDescriptor desc = (IBrowserDescriptor)selectedBrowser;
            configuration.setAttribute("runtimeExecutable", desc.getLocation());
        } else if (selectedBrowser instanceof String) {
            configuration.setAttribute("runtimeExecutable", selectedBrowser);
        }
    }

    public String getName() {
        return Messages.ChromeAttachTab_browserTab;
    }

    public Image getImage() {
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = null;
    }

    static class BrowserLabelProvider
    extends LabelProvider {
        BrowserLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IBrowserDescriptor) {
                IBrowserDescriptor browser = (IBrowserDescriptor)element;
                return browser.getName();
            }
            if ("".equals(element)) {
                return "[Default]";
            }
            return super.getText(element);
        }
    }
}

