/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.PointList;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.ParentTargetDragEditPartTracker;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public class FormHeaderEditPart<C extends IControlInfo>
extends GraphicalEditPart {
    private final boolean isHorizontal;
    private final IFormLayoutInfo<C> layout;
    private final Transposer t;
    private final Figure containerFigure;

    public FormHeaderEditPart(IFormLayoutInfo<C> layout, Object model, boolean isHorizontal, Figure containerFigure) {
        this.layout = layout;
        this.isHorizontal = isHorizontal;
        this.containerFigure = containerFigure;
        this.t = new Transposer(!isHorizontal);
        this.setModel(model);
    }

    protected Figure createFigure() {
        return new PercentFigure(this.isHorizontal);
    }

    protected void refreshVisuals() {
        int size = this.t.t((Dimension)this.layout.getContainerSize()).width;
        int percent = this.getPercent(this.getModel());
        int marginOffset = this.isHorizontal ? FormUtils.getLayoutMarginLeft(this.layout) : FormUtils.getLayoutMarginTop(this.layout);
        int position = size * percent / 100 + marginOffset;
        Figure figure = this.getFigure();
        figure.setToolTipText(String.valueOf(String.valueOf(percent)) + "%");
        int figureSize = this.t.t((Dimension)figure.getParent().getSize()).height;
        Rectangle bounds = this.t.t(new Rectangle(position - figureSize / 2, 0, figureSize, figureSize));
        figure.setBounds(this.translateModelToFeedback(bounds));
    }

    private int getPercent(Object model) {
        return ((FormLayoutPreferences.PercentsInfo)model).value;
    }

    private Point getOffset() {
        return FormHeaderLayoutEditPolicy.getOffset(this.containerFigure, this.layout.getComposite());
    }

    private Rectangle translateModelToFeedback(Rectangle r) {
        if (this.isHorizontal) {
            PolicyUtils.modelToFeedback_rightToLeft((Translatable)r, (IAbstractComponentInfo)this.layout.getComposite());
        }
        r = this.t.t(r);
        return this.t.t(r.getTranslated(this.t.t((Point)this.getOffset()).x, 0));
    }

    public final Tool getDragTrackerTool(Request request) {
        return new ParentTargetDragEditPartTracker((EditPart)this);
    }

    static final class PercentFigure
    extends Figure {
        private final Transposer m_t;

        public PercentFigure(boolean isHorizontal) {
            this.m_t = new Transposer(!isHorizontal);
        }

        protected void paintClientArea(Graphics graphics) {
            Dimension size = this.m_t.t(this.getSize());
            graphics.setBackgroundColor(IColorConstants.buttonDarker);
            PointList points = new PointList();
            points.addPoint(this.m_t.t(new Point(3, size.height / 2)));
            points.addPoint(this.m_t.t(new Point(size.width / 2, size.height)));
            points.addPoint(this.m_t.t(new Point(11, size.height / 2)));
            graphics.fillPolygon(points);
        }
    }
}

