/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#include "action.h"

Action::Action():
    m_level(50),
    m_processed(false)
{
}

Action::Action(const Action &copy)
{
    m_level = copy.m_level;
    m_type = copy.m_type;
    m_attr = copy.m_attr;
    m_processed = copy.m_processed;
}

void Action::setType(type_t type)
{
    m_type = type;
}

void Action::setLevel(int level)
{
    m_level = level;
}

void Action::setAttr(const QString &attr)
{
    m_attr = attr;
}

void Action::setProcessed(bool processed)
{
    m_processed = processed;
}

Action::type_t Action::type() const
{
    return m_type;
}

int Action::level() const
{
    return m_level;
}

QString Action::attr() const
{
    return m_attr;
}

bool Action::processed() const
{
    return m_processed;
}

bool Action::operator== (const Action &right) const
{
    return m_level == right.m_level;
}

bool Action::operator!= (const Action &right) const
{
    return m_level != right.m_level;
}

bool Action::operator< (const Action &right) const
{
    return m_level < right.m_level;
}

bool Action::operator<= (const Action &right) const
{
    return m_level <= right.m_level;
}

bool Action::operator> (const Action &right) const
{
    return m_level > right.m_level;
}

bool Action::operator>= (const Action &right) const
{
    return m_level >= right.m_level;
}
