/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef BATTERYMETER_H
#define BATTERYMETER_H

#include <QString>

class BatteryMeter
{
public:
    typedef enum {CHARGING, DISCHARGING, CHARGED, UNKNOWN} charge_t;

public:
    BatteryMeter();
    ~BatteryMeter();

    void update();

    bool batteryPresent() const;
    bool acOnline() const;
    unsigned long designCapa() const;
    unsigned long remainCapa() const;
    unsigned long remainTime() const; //seconds
    unsigned long percentage() const;
    long rate() const;
    charge_t state() const;

private:
    bool m_present;
    bool m_ac_online;
    unsigned long m_design_capa;
    unsigned long m_remain_capa;
    unsigned long m_remain_time;
    unsigned long m_percentage;
    long m_rate;
    charge_t m_state;
};

#endif // BATTERYMETER_H
