/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef _INFO_DIALOG_H_
#define _INFO_DIALOG_H_

#include <QDialog>
#include "ui_infodialog.h"
#include "batterymeter.h"

class InfoDialog: public QDialog, private Ui::infoDlg
{
    Q_OBJECT

public:
    InfoDialog(QWidget *parent = 0);
    ~InfoDialog();

    void setPercentage(int perc);
    void setCapacity(unsigned long act, unsigned long max);
    void setRate(long rate);
    void setBatteryState(BatteryMeter::charge_t state);
    void setAcState(bool online);
    void setTimeRemaining(unsigned long min);

public slots:
    void show();

protected:
    void mousePressEvent(QMouseEvent *ev);
};

#endif
