/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#include "batterymetergui.h"
#include "settings.h"
#include <QApplication>
#include <QScopedPointer>

extern "C" {
#include <getopt.h>
}

int main(int argc, char **argv)
{
    int c;
    int interval = -1;
    while ((c = getopt(argc, argv, "i:")) != -1)
    {
        if (c == 'i')
        {
            interval = atoi(optarg);
            break;
        }
    }

    QApplication app(argc, argv);
    QApplication::setApplicationName("BatteryMeter");
    QApplication::setQuitOnLastWindowClosed(false);

    QScopedPointer <BatteryMeterGui> batt(new BatteryMeterGui());
    batt->update();
    batt->show();

    if (interval != -1)
        batt->start(interval * 1000);
    else
        batt->start();


    app.exec();


    return 0;
}
