/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#include "shutdown.h"
#include "common.h"
#include <iostream>
#include <QLibrary>
#include <QProcess>

#ifdef Q_OS_WIN32
extern "C" {
#include <powrprof.h>
}
#endif

Shutdown::Shutdown()
{
}

Shutdown::~Shutdown()
{
}

void Shutdown::shutdown()
{
#ifdef Q_OS_WIN32
    QProcess::execute("shutdown /s /t 0 /f");
#endif
}

void Shutdown::reboot()
{
#ifdef Q_OS_WIN32
    QProcess::execute("shutdown /r /t 0 /f");
#endif
}

void Shutdown::logoff()
{
#ifdef Q_OS_WIN32
    QProcess::execute("shutdown /l /t 0 /f");
#endif
}

void Shutdown::suspend(bool force)
{
    Q_UNUSED(force);
#ifdef Q_OS_WIN32
    QProcess::execute(QString("rundll32.exe powrprof.dll,SetSuspendState 0,%1,0")
                      .arg(force ? 1 : 0));
#endif

}

void Shutdown::hibernate(bool force)
{
    Q_UNUSED(force);
#ifdef Q_OS_WIN32
    QProcess::execute("rundll32.exe PowrProf.dll,SetSuspendState");
#endif
}
