/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef WINDOWSREGISTRY_H
#define WINDOWSREGISTRY_H

extern "C" {
#include <windows.h>
}

#include <string>

class WindowsRegistry {
public:
    static bool keyExists(HKEY rootKey, const std::string &key);
    static bool entryExists(HKEY rootKey, const std::string &subkey,
                            const std::string &entry);
    static std::string getValue(HKEY rootKey, const std::string &subkey,
                                const std::string &entry);
    static bool createKey(HKEY rootKey, const std::string &subkey,
                          const std::string &key, const std::string &defaultValue = "");
    static bool deleteKey(HKEY rootKey, const std::string &subkey,
                          const std::string &key);
    static bool createEntry(HKEY rootKey, const std::string &subkey,
                            const std::string &entry, const std::string &value);
    static bool createEntry(HKEY rootKey, const std::string &subkey,
                            const std::string &entry, DWORD value);
    static bool removeEntry(HKEY rootKey, const std::string &subkey,
                            const std::string &entry);
};

#endif	//WINDOWSREGISTRY_H
